/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.workbench;

import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetradapp.util.CopyLayoutAction;
import edu.cmu.tetradapp.util.LayoutEditable;
import edu.cmu.tetradapp.util.PasteLayoutAction;
import edu.cmu.tetradapp.workbench.CausalOrder;
import edu.cmu.tetradapp.workbench.LayoutUtils;
import java.util.ArrayList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class LayoutMenu
extends JMenu {
    private final LayoutEditable layoutEditable;
    private final CopyLayoutAction copyLayoutAction;

    public LayoutMenu(LayoutEditable layoutEditable) {
        super("Layout");
        this.layoutEditable = layoutEditable;
        if (layoutEditable.getGraph().isTimeLagModel()) {
            JMenuItem topToBottom = new JMenuItem("Top to bottom");
            this.add(topToBottom);
            topToBottom.addActionListener(e -> {
                LayoutUtils.topToBottomLayout(this.getLayoutEditable());
                this.getCopyLayoutAction().actionPerformed(null);
            });
            JMenuItem leftToRight = new JMenuItem("Left to right");
            this.add(leftToRight);
            leftToRight.addActionListener(e -> {
                LayoutUtils.leftToRightLayout(this.getLayoutEditable());
                this.getCopyLayoutAction().actionPerformed(null);
            });
            JMenuItem bottomToTop = new JMenuItem("Bottom to top");
            this.add(bottomToTop);
            bottomToTop.addActionListener(e -> {
                LayoutUtils.bottomToTopLayout(this.getLayoutEditable());
                this.getCopyLayoutAction().actionPerformed(null);
            });
            JMenuItem rightToLeft = new JMenuItem("Right to left");
            this.add(rightToLeft);
            rightToLeft.addActionListener(e -> {
                LayoutUtils.rightToLeftLayout(this.getLayoutEditable());
                this.getCopyLayoutAction().actionPerformed(null);
            });
            JMenuItem likeLag0 = new JMenuItem("Copy lag 0");
            this.add(likeLag0);
            likeLag0.addActionListener(e -> {
                if (LayoutUtils.getLayout() == LayoutUtils.Layout.topToBottom || LayoutUtils.getLayout() == LayoutUtils.Layout.lag0TopToBottom) {
                    LayoutUtils.copyLag0LayoutTopToBottom(this.getLayoutEditable());
                } else if (LayoutUtils.getLayout() == LayoutUtils.Layout.bottomToTop || LayoutUtils.getLayout() == LayoutUtils.Layout.lag0BottomToTop) {
                    LayoutUtils.copyLag0LayoutBottomToTop(this.getLayoutEditable());
                } else if (LayoutUtils.getLayout() == LayoutUtils.Layout.leftToRight || LayoutUtils.getLayout() == LayoutUtils.Layout.lag0LeftToRight) {
                    LayoutUtils.copyLag0LayoutLeftToRight(this.getLayoutEditable());
                } else if (LayoutUtils.getLayout() == LayoutUtils.Layout.rightToLeft || LayoutUtils.getLayout() == LayoutUtils.Layout.lag0RightToLeft) {
                    LayoutUtils.copyLag0LayoutRightToLeft(this.getLayoutEditable());
                }
                this.getCopyLayoutAction().actionPerformed(null);
            });
            this.addSeparator();
        }
        JMenuItem circleLayout = new JMenuItem("Circle");
        this.add(circleLayout);
        circleLayout.addActionListener(e -> {
            LayoutUtils.circleLayout(this.getLayoutEditable());
            this.getCopyLayoutAction().actionPerformed(null);
        });
        if (this.getLayoutEditable().getKnowledge() != null) {
            JMenuItem knowledgeTiersLayout = new JMenuItem("Knowledge Tiers");
            this.add(knowledgeTiersLayout);
            knowledgeTiersLayout.addActionListener(e -> {
                LayoutUtils.knowledgeLayout(this.getLayoutEditable());
                this.getCopyLayoutAction().actionPerformed(null);
            });
        }
        JMenuItem fruchtermanReingold = new JMenuItem("Fruchterman-Reingold");
        this.add(fruchtermanReingold);
        fruchtermanReingold.addActionListener(e -> {
            LayoutUtils.fruchtermanReingoldLayout(this.getLayoutEditable());
            this.getCopyLayoutAction().actionPerformed(null);
        });
        JMenuItem kamadaKawai = new JMenuItem("Kamada-Kawai");
        this.add(kamadaKawai);
        kamadaKawai.addActionListener(e -> {
            LayoutEditable layoutEditable1 = this.getLayoutEditable();
            LayoutUtils.kamadaKawaiLayout(layoutEditable1);
            this.getCopyLayoutAction().actionPerformed(null);
        });
        JMenuItem distanceFromSelected = new JMenuItem("Distance From Selected");
        this.add(distanceFromSelected);
        distanceFromSelected.addActionListener(e -> {
            LayoutEditable layoutEditable12 = this.getLayoutEditable();
            LayoutUtils.distanceFromSelectedLayout(layoutEditable12);
            this.getCopyLayoutAction().actionPerformed(null);
        });
        JMenuItem causalOrder = new JMenuItem("Causal Order");
        this.add(causalOrder);
        causalOrder.addActionListener(e -> {
            LayoutEditable layoutEditable13 = this.getLayoutEditable();
            Graph graph = layoutEditable13.getGraph();
            for (Node node : new ArrayList<Node>(graph.getNodes())) {
                if (node.getNodeType() != NodeType.ERROR) continue;
                graph.removeNode(node);
            }
            CausalOrder layout1 = new CausalOrder(layoutEditable13);
            layout1.doLayout();
            layoutEditable13.layoutByGraph(graph);
            LayoutUtils.layout = LayoutUtils.Layout.distanceFromSelected;
            this.getCopyLayoutAction().actionPerformed(null);
        });
        this.addSeparator();
        this.copyLayoutAction = new CopyLayoutAction(this.getLayoutEditable());
        this.add(this.getCopyLayoutAction());
        this.add(new PasteLayoutAction(this.getLayoutEditable()));
    }

    private LayoutEditable getLayoutEditable() {
        return this.layoutEditable;
    }

    private CopyLayoutAction getCopyLayoutAction() {
        return this.copyLayoutAction;
    }
}

