/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.workbench;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.LayoutUtil;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.graph.SemGraph;
import edu.cmu.tetrad.graph.TimeLagGraph;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.util.JOptionUtils;
import edu.cmu.tetradapp.util.GraphEditorUtils;
import edu.cmu.tetradapp.util.LayoutEditable;
import edu.cmu.tetradapp.workbench.DistanceFromSelected;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import org.apache.commons.math3.util.FastMath;

public class LayoutUtils {
    static Layout layout = Layout.topToBottom;

    public static void setLayout(Layout _layout) {
        layout = _layout;
    }

    public static Layout getLayout() {
        return layout;
    }

    public static void setAllSizes(Component comp, Dimension dim) {
        comp.setPreferredSize(dim);
        comp.setMaximumSize(dim);
        comp.setMinimumSize(dim);
        comp.setSize(dim);
    }

    public static Box leftAlignJLabel(JLabel label) {
        Box box = Box.createHorizontalBox();
        box.add(label);
        box.add(Box.createHorizontalGlue());
        return box;
    }

    public static void copyLag0LayoutTopToBottom(LayoutEditable layoutEditable) {
        TimeLagGraph graph = layoutEditable.getGraph().getTimeLagGraph();
        List<Node> lag0Nodes = graph.getLag0Nodes();
        lag0Nodes.sort(Comparator.comparingInt(Node::getCenterX));
        int minLag0Y = Integer.MAX_VALUE;
        int maxLag0Y = Integer.MIN_VALUE;
        for (Node node : lag0Nodes) {
            if (node.getCenterY() < minLag0Y) {
                minLag0Y = node.getCenterY();
            }
            if (node.getCenterY() <= maxLag0Y) continue;
            maxLag0Y = node.getCenterY();
        }
        int lag0YDiff = maxLag0Y - minLag0Y;
        int ySpace = FastMath.max(lag0YDiff + 25, 100);
        int minY = Integer.MAX_VALUE;
        for (Node node : lag0Nodes) {
            int x = node.getCenterX();
            int y = node.getCenterY();
            TimeLagGraph.NodeId id = graph.getNodeId(node);
            for (int lag = 0; lag <= graph.getMaxLag(); ++lag) {
                y -= ySpace;
                Node _node = graph.getNode(id.getName(), lag);
                if (_node == null) {
                    System.out.println("Couldn't find node.");
                    continue;
                }
                _node.setCenterX(x);
                _node.setCenterY(y);
                if (y >= minY) continue;
                minY = y;
            }
        }
        int diffY = 50 - minY;
        for (Node node : lag0Nodes) {
            TimeLagGraph.NodeId id = graph.getNodeId(node);
            for (int lag = 0; lag <= graph.getMaxLag(); ++lag) {
                Node _node = graph.getNode(id.getName(), lag);
                _node.setCenterY(_node.getCenterY() + diffY);
            }
        }
        layoutEditable.layoutByGraph(graph);
        layout = Layout.lag0TopToBottom;
    }

    public static void copyLag0LayoutBottomToTop(LayoutEditable layoutEditable) {
        TimeLagGraph graph = layoutEditable.getGraph().getTimeLagGraph();
        List<Node> lag0Nodes = graph.getLag0Nodes();
        lag0Nodes.sort(Comparator.comparingInt(Node::getCenterX));
        int minLag0Y = Integer.MAX_VALUE;
        int maxLag0Y = Integer.MIN_VALUE;
        for (Node node : lag0Nodes) {
            if (node.getCenterY() < minLag0Y) {
                minLag0Y = node.getCenterY();
            }
            if (node.getCenterY() <= maxLag0Y) continue;
            maxLag0Y = node.getCenterY();
        }
        int lag0YDiff = maxLag0Y - minLag0Y;
        int ySpace = FastMath.max(lag0YDiff + 25, 100);
        int minY = Integer.MAX_VALUE;
        for (Node node : lag0Nodes) {
            int x = node.getCenterX();
            int y = node.getCenterY();
            TimeLagGraph.NodeId id = graph.getNodeId(node);
            for (int lag = graph.getMaxLag(); lag >= 0; --lag) {
                y -= ySpace;
                Node _node = graph.getNode(id.getName(), lag);
                if (_node == null) {
                    System.out.println("Couldn't find node.");
                    continue;
                }
                _node.setCenterX(x);
                _node.setCenterY(y);
                if (y >= minY) continue;
                minY = y;
            }
        }
        int diffY = 50 - minY;
        for (Node node : lag0Nodes) {
            TimeLagGraph.NodeId id = graph.getNodeId(node);
            for (int lag = graph.getMaxLag(); lag >= 0; --lag) {
                Node _node = graph.getNode(id.getName(), lag);
                _node.setCenterY(_node.getCenterY() + diffY);
            }
        }
        layoutEditable.layoutByGraph(graph);
        layout = Layout.lag0BottomToTop;
    }

    public static void copyLag0LayoutLeftToRight(LayoutEditable layoutEditable) {
        TimeLagGraph graph = layoutEditable.getGraph().getTimeLagGraph();
        List<Node> lag0Nodes = graph.getLag0Nodes();
        lag0Nodes.sort(Comparator.comparingInt(Node::getCenterX));
        int minLag0X = Integer.MAX_VALUE;
        int maxLag0X = Integer.MIN_VALUE;
        for (Node node : lag0Nodes) {
            if (node.getCenterX() < minLag0X) {
                minLag0X = node.getCenterX();
            }
            if (node.getCenterX() <= maxLag0X) continue;
            maxLag0X = node.getCenterX();
        }
        int lag0XDiff = maxLag0X - minLag0X;
        int xSpace = FastMath.max(lag0XDiff + 25, 90);
        int minX = Integer.MAX_VALUE;
        for (Node node : lag0Nodes) {
            int x = node.getCenterX();
            int y = node.getCenterY();
            TimeLagGraph.NodeId id = graph.getNodeId(node);
            for (int lag = 0; lag <= graph.getMaxLag(); ++lag) {
                x -= xSpace;
                Node _node = graph.getNode(id.getName(), lag);
                if (_node == null) {
                    System.out.println("Couldn't find node.");
                    continue;
                }
                _node.setCenterX(x);
                _node.setCenterY(y);
                if (x >= minX) continue;
                minX = x;
            }
        }
        int diffX = 50 - minX;
        for (Node node : lag0Nodes) {
            TimeLagGraph.NodeId id = graph.getNodeId(node);
            for (int lag = 0; lag <= graph.getMaxLag(); ++lag) {
                Node _node = graph.getNode(id.getName(), lag);
                _node.setCenterX(_node.getCenterX() + diffX);
            }
        }
        layoutEditable.layoutByGraph(graph);
        layout = Layout.lag0LeftToRight;
    }

    public static void copyLag0LayoutRightToLeft(LayoutEditable layoutEditable) {
        TimeLagGraph graph = layoutEditable.getGraph().getTimeLagGraph();
        List<Node> lag0Nodes = graph.getLag0Nodes();
        lag0Nodes.sort(Comparator.comparingInt(Node::getCenterX));
        int minLag0X = Integer.MAX_VALUE;
        int maxLag0X = Integer.MIN_VALUE;
        for (Node node : lag0Nodes) {
            if (node.getCenterX() < minLag0X) {
                minLag0X = node.getCenterX();
            }
            if (node.getCenterX() <= maxLag0X) continue;
            maxLag0X = node.getCenterX();
        }
        int lag0XDiff = maxLag0X - minLag0X;
        int xSpace = FastMath.max(lag0XDiff + 25, 90);
        int minX = Integer.MAX_VALUE;
        for (Node node : lag0Nodes) {
            int x = node.getCenterX();
            int y = node.getCenterY();
            TimeLagGraph.NodeId id = graph.getNodeId(node);
            for (int lag = graph.getMaxLag(); lag >= 0; --lag) {
                x -= xSpace;
                Node _node = graph.getNode(id.getName(), lag);
                if (_node == null) {
                    System.out.println("Couldn't find node.");
                    continue;
                }
                _node.setCenterX(x);
                _node.setCenterY(y);
                if (x >= minX) continue;
                minX = x;
            }
        }
        int diffX = 50 - minX;
        for (Node node : lag0Nodes) {
            TimeLagGraph.NodeId id = graph.getNodeId(node);
            for (int lag = graph.getMaxLag(); lag >= 0; --lag) {
                Node _node = graph.getNode(id.getName(), lag);
                _node.setCenterX(_node.getCenterX() + diffX);
            }
        }
        layoutEditable.layoutByGraph(graph);
        layout = Layout.lag0RightToLeft;
    }

    public static void topToBottomLayout(LayoutEditable layoutEditable) {
        TimeLagGraph graph = layoutEditable.getGraph().getTimeLagGraph();
        int xStart = 65;
        int yStart = 50;
        int xSpace = 100;
        int ySpace = 100;
        List<Node> lag0Nodes = graph.getLag0Nodes();
        lag0Nodes.sort(Comparator.comparingInt(Node::getCenterX));
        int x = -35;
        for (Node node : lag0Nodes) {
            x += 100;
            int y = -50;
            TimeLagGraph.NodeId id = graph.getNodeId(node);
            for (int lag = graph.getMaxLag(); lag >= 0; --lag) {
                y += 100;
                Node _node = graph.getNode(id.getName(), lag);
                if (_node == null) {
                    System.out.println("Couldn't find node.");
                    continue;
                }
                _node.setCenterX(x);
                _node.setCenterY(y);
            }
        }
        layoutEditable.layoutByGraph(graph);
        layout = Layout.topToBottom;
    }

    public static void leftToRightLayout(LayoutEditable layoutEditable) {
        TimeLagGraph graph = layoutEditable.getGraph().getTimeLagGraph();
        int xStart = 65;
        int yStart = 50;
        int xSpace = 100;
        int ySpace = 100;
        List<Node> lag0Nodes = graph.getLag0Nodes();
        lag0Nodes.sort(Comparator.comparingInt(Node::getCenterX));
        int y = -50;
        for (Node node : lag0Nodes) {
            y += 100;
            int x = -35;
            TimeLagGraph.NodeId id = graph.getNodeId(node);
            for (int lag = graph.getMaxLag(); lag >= 0; --lag) {
                x += 100;
                Node _node = graph.getNode(id.getName(), lag);
                if (_node == null) {
                    System.out.println("Couldn't find node.");
                    continue;
                }
                _node.setCenterX(x);
                _node.setCenterY(y);
            }
        }
        layoutEditable.layoutByGraph(graph);
        layout = Layout.leftToRight;
    }

    public static void bottomToTopLayout(LayoutEditable layoutEditable) {
        TimeLagGraph graph = layoutEditable.getGraph().getTimeLagGraph();
        int xStart = 65;
        int yStart = 50;
        int xSpace = 100;
        int ySpace = 100;
        List<Node> lag0Nodes = graph.getLag0Nodes();
        lag0Nodes.sort(Comparator.comparingInt(Node::getCenterX));
        int x = -35;
        for (Node node : lag0Nodes) {
            x += 100;
            int y = -50;
            TimeLagGraph.NodeId id = graph.getNodeId(node);
            for (int lag = 0; lag <= graph.getMaxLag(); ++lag) {
                y += 100;
                Node _node = graph.getNode(id.getName(), lag);
                if (_node == null) {
                    System.out.println("Couldn't find node.");
                    continue;
                }
                _node.setCenterX(x);
                _node.setCenterY(y);
            }
        }
        layoutEditable.layoutByGraph(graph);
        layout = Layout.bottomToTop;
    }

    public static void rightToLeftLayout(LayoutEditable layoutEditable) {
        TimeLagGraph graph = layoutEditable.getGraph().getTimeLagGraph();
        int xStart = 65;
        int yStart = 50;
        int xSpace = 100;
        int ySpace = 100;
        List<Node> lag0Nodes = graph.getLag0Nodes();
        lag0Nodes.sort(Comparator.comparingInt(Node::getCenterX));
        int y = -50;
        for (Node node : lag0Nodes) {
            y += 100;
            int x = -35;
            TimeLagGraph.NodeId id = graph.getNodeId(node);
            for (int lag = 0; lag <= graph.getMaxLag(); ++lag) {
                x += 100;
                Node _node = graph.getNode(id.getName(), lag);
                if (_node == null) {
                    System.out.println("Couldn't find node.");
                    continue;
                }
                _node.setCenterX(x);
                _node.setCenterY(y);
            }
        }
        layoutEditable.layoutByGraph(graph);
        layout = Layout.rightToLeft;
    }

    public static void layeredDrawingLayout(LayoutEditable layoutEditable) {
        Graph graph = layoutEditable.getGraph();
        for (Node node : new ArrayList<Node>(graph.getNodes())) {
            if (node.getNodeType() != NodeType.ERROR) continue;
            graph.removeNode(node);
        }
        LayoutUtil.circleLayout(graph, 225, 200, 150);
        layoutEditable.layoutByGraph(graph);
        layout = Layout.layered;
    }

    private static void sourceGraphLayout(LayoutEditable layoutEditable) {
        EdgeListGraph graph = new EdgeListGraph(layoutEditable.getGraph());
        for (Node node : new ArrayList<Node>(graph.getNodes())) {
            if (node.getNodeType() != NodeType.ERROR) continue;
            graph.removeNode(node);
        }
        Graph sourceGraph = layoutEditable.getSourceGraph();
        LayoutUtil.arrangeBySourceGraph(graph, sourceGraph);
        layoutEditable.layoutByGraph(graph);
        layout = Layout.source;
    }

    public static void knowledgeLayout(LayoutEditable layoutEditable) {
        EdgeListGraph graph = new EdgeListGraph(layoutEditable.getGraph());
        try {
            for (Node node : new ArrayList<Node>(graph.getNodes())) {
                if (node.getNodeType() != NodeType.ERROR) continue;
                graph.removeNode(node);
            }
            Knowledge knowledge = layoutEditable.getKnowledge();
            SearchGraphUtils.arrangeByKnowledgeTiers(graph, knowledge);
            layoutEditable.layoutByGraph(graph);
        }
        catch (Exception e1) {
            JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), e1.getMessage());
        }
        layout = Layout.knowledge;
    }

    public static void circleLayout(LayoutEditable layoutEditable) {
        Graph graph = layoutEditable.getGraph();
        for (Node node : new ArrayList<Node>(graph.getNodes())) {
            if (node.getNodeType() != NodeType.ERROR) continue;
            ((SemGraph)graph).setShowErrorTerms(false);
        }
        Rectangle r = layoutEditable.getVisibleRect();
        int m = FastMath.min(r.width, r.height) / 2;
        int radius = m - 50;
        int centerx = r.x + m;
        int centery = r.y + m;
        LayoutUtil.circleLayout(graph, centerx, centery, radius);
        layoutEditable.layoutByGraph(graph);
        layout = Layout.circle;
    }

    public static void kamadaKawaiLayout(LayoutEditable layoutEditable) {
        Graph graph = layoutEditable.getGraph();
        Runnable runnable = () -> {
            for (Node node : new ArrayList<Node>(graph.getNodes())) {
                if (node.getNodeType() != NodeType.ERROR) continue;
                ((SemGraph)graph).setShowErrorTerms(false);
            }
            GraphEditorUtils.editkamadaKawaiLayoutParams();
            boolean initializeRandomly = Preferences.userRoot().getBoolean("kamadaKawaiLayoutInitializeRandomly", false);
            double naturalEdgeLength = Preferences.userRoot().getDouble("kamadaKawaiLayoutNaturalEdgeLength", 80.0);
            double springConstant = Preferences.userRoot().getDouble("kamadaKawaiLayoutSpringConstant", 0.2);
            double stopEnergy = Preferences.userRoot().getDouble("kamadaKawaiLayoutStopEnergy", 1.0);
            LayoutUtil.kamadaKawaiLayout(graph, initializeRandomly, naturalEdgeLength, springConstant, stopEnergy);
            layoutEditable.layoutByGraph(graph);
            layout = Layout.kamadaKawai;
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }

    public static void fruchtermanReingoldLayout(LayoutEditable layoutEditable) {
        Graph graph = layoutEditable.getGraph();
        for (Node node : new ArrayList<Node>(graph.getNodes())) {
            if (node.getNodeType() != NodeType.ERROR) continue;
            ((SemGraph)graph).setShowErrorTerms(false);
        }
        LayoutUtil.fruchtermanReingoldLayout(graph);
        layoutEditable.layoutByGraph(graph);
        layout = Layout.fruchtermReingold;
    }

    public static void distanceFromSelectedLayout(LayoutEditable layoutEditable) {
        Graph graph = layoutEditable.getGraph();
        for (Node node : new ArrayList<Node>(graph.getNodes())) {
            if (node.getNodeType() != NodeType.ERROR) continue;
            graph.removeNode(node);
        }
        DistanceFromSelected layout1 = new DistanceFromSelected(layoutEditable);
        layout1.doLayout();
        layoutEditable.layoutByGraph(graph);
        layout = Layout.distanceFromSelected;
    }

    public static void lastLayout(LayoutEditable layoutEditable) {
        switch (layout) {
            case lag0TopToBottom: {
                LayoutUtils.copyLag0LayoutTopToBottom(layoutEditable);
                break;
            }
            case lag0BottomToTop: {
                LayoutUtils.copyLag0LayoutBottomToTop(layoutEditable);
                break;
            }
            case lag0LeftToRight: {
                LayoutUtils.copyLag0LayoutLeftToRight(layoutEditable);
                break;
            }
            case lag0RightToLeft: {
                LayoutUtils.copyLag0LayoutRightToLeft(layoutEditable);
                break;
            }
            case topToBottom: {
                LayoutUtils.topToBottomLayout(layoutEditable);
                break;
            }
            case bottomToTop: {
                LayoutUtils.bottomToTopLayout(layoutEditable);
                break;
            }
            case leftToRight: {
                LayoutUtils.leftToRightLayout(layoutEditable);
                break;
            }
            case rightToLeft: {
                LayoutUtils.rightToLeftLayout(layoutEditable);
                break;
            }
            case layered: {
                LayoutUtils.layeredDrawingLayout(layoutEditable);
                break;
            }
            case source: {
                LayoutUtils.sourceGraphLayout(layoutEditable);
                break;
            }
            case knowledge: {
                LayoutUtils.knowledgeLayout(layoutEditable);
                break;
            }
            case circle: {
                LayoutUtils.circleLayout(layoutEditable);
                break;
            }
            case kamadaKawai: {
                LayoutUtils.kamadaKawaiLayout(layoutEditable);
                break;
            }
            case fruchtermReingold: {
                LayoutUtils.fruchtermanReingoldLayout(layoutEditable);
                break;
            }
        }
    }

    public static enum Layout {
        lag0TopToBottom,
        lag0BottomToTop,
        lag0LeftToRight,
        lag0RightToLeft,
        topToBottom,
        bottomToTop,
        leftToRight,
        rightToLeft,
        layered,
        source,
        knowledge,
        circle,
        kamadaKawai,
        fruchtermReingold,
        distanceFromSelected;

    }
}

