/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.workbench;

import edu.cmu.tetradapp.workbench.DisplayComp;
import edu.cmu.tetradapp.workbench.DisplayNodeUtils;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;

public class MeasuredDisplayComp
extends JComponent
implements DisplayComp {
    private boolean selected;

    public MeasuredDisplayComp(String name) {
        this.setBackground(DisplayNodeUtils.getNodeFillColor());
        this.setFont(DisplayNodeUtils.getFont());
        this.setName(name);
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        this.setSize(this.getPreferredSize());
    }

    @Override
    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    @Override
    public boolean contains(int x, int y) {
        return this.getShape().contains(x, y);
    }

    private Shape getShape() {
        return new RoundRectangle2D.Double(0.0, 0.0, this.getPreferredSize().width - 1, this.getPreferredSize().height - 1, 4.0, 3.0);
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        FontMetrics fm = this.getFontMetrics(DisplayNodeUtils.getFont());
        int width = this.getPreferredSize().width;
        int stringWidth = fm.stringWidth(this.getName());
        int stringX = (width - stringWidth) / 2;
        int stringY = fm.getAscent() + DisplayNodeUtils.getPixelGap();
        g2.setColor(this.isSelected() ? DisplayNodeUtils.getNodeSelectedFillColor() : DisplayNodeUtils.getNodeFillColor());
        g2.fill(this.getShape());
        g2.setColor(this.isSelected() ? DisplayNodeUtils.getNodeSelectedEdgeColor() : DisplayNodeUtils.getNodeEdgeColor());
        g2.draw(this.getShape());
        g2.setColor(DisplayNodeUtils.getNodeTextColor());
        g2.setFont(DisplayNodeUtils.getFont());
        g2.drawString(this.getName(), stringX, stringY);
    }

    @Override
    public Dimension getPreferredSize() {
        FontMetrics fm = this.getFontMetrics(DisplayNodeUtils.getFont());
        int width = fm.stringWidth(this.getName()) + fm.getMaxAdvance();
        int height = 2 * DisplayNodeUtils.getPixelGap() + fm.getAscent() + 3;
        width = width < 60 ? 60 : width;
        return new Dimension(width, height);
    }

    private boolean isSelected() {
        return this.selected;
    }
}

