/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.workbench;

import edu.cmu.tetradapp.workbench.DisplayComp;
import edu.cmu.tetradapp.workbench.DisplayNodeUtils;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import javax.swing.JComponent;

public class MeasuredDisplaySmallComp
extends JComponent
implements DisplayComp {
    private boolean selected;

    public MeasuredDisplaySmallComp(String name) {
        this.setBackground(DisplayNodeUtils.getNodeFillColor());
        this.setFont(DisplayNodeUtils.getFont());
        this.setName(name);
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        this.setSize(this.getPreferredSize());
    }

    @Override
    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    @Override
    public boolean contains(int x, int y) {
        return this.getShape().contains(x, y);
    }

    private Shape getShape() {
        return new Ellipse2D.Double(0.0, 0.0, this.getPreferredSize().width - 1, this.getPreferredSize().height - 1);
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        FontMetrics fm = this.getFontMetrics(new Font("Monospaced", 0, 3));
        String name = this.getName();
        if (name.startsWith("X")) {
            name = name.substring(1);
        }
        int stringX = 2;
        int stringY = 4 * fm.getAscent() + DisplayNodeUtils.getPixelGap();
        g2.setColor(this.isSelected() ? DisplayNodeUtils.getNodeSelectedFillColor() : DisplayNodeUtils.getNodeFillColor());
        g2.fill(this.getShape());
        g2.setColor(this.isSelected() ? DisplayNodeUtils.getNodeSelectedEdgeColor() : DisplayNodeUtils.getNodeEdgeColor());
        g2.draw(this.getShape());
        g2.setColor(DisplayNodeUtils.getNodeTextColor());
        g2.setFont(DisplayNodeUtils.getFont());
        g2.drawString(name, 2, stringY);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(30, 30);
    }

    private boolean isSelected() {
        return this.selected;
    }
}

