/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.workbench;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;
import org.apache.commons.math3.util.FastMath;

class Rubberband
extends JComponent {
    private final Shape shape = new RoundRectangle2D.Double();
    private final BasicStroke stroke;
    private final Point anchor;

    public Rubberband(Point anchor) {
        if (anchor == null) {
            throw new NullPointerException("Anchor point must not be null.");
        }
        this.anchor = anchor;
        boolean width = true;
        boolean cap = true;
        int join = 2;
        boolean miterlimit = false;
        float[] dash = new float[]{2.0f, 2.0f, 4.0f, 2.0f};
        float dashphase = 0.0f;
        this.stroke = new BasicStroke(1.0f, 1, 2, 0.0f, dash, 0.0f);
        this.setLocation(anchor);
        this.setSize(0, 0);
    }

    public void updateTrackPoint(Point p) {
        int newLocX = FastMath.min(p.x, this.anchor.x);
        int newLocY = FastMath.min(p.y, this.anchor.y);
        int deltaX = FastMath.abs(p.x - this.anchor.x);
        int deltaY = FastMath.abs(p.y - this.anchor.y);
        this.setLocation(newLocX, newLocY);
        this.setSize(deltaX, deltaY);
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        this.resetShapeBounds();
        g2.setColor(Color.black);
        g2.setStroke(this.stroke);
        g2.draw(this.shape);
    }

    private void resetShapeBounds() {
        RoundRectangle2D.Double rrect = (RoundRectangle2D.Double)this.shape;
        rrect.setRoundRect(0.0, 0.0, this.getBounds().width - 1, this.getBounds().height - 1, 10.0, 10.0);
    }

    public Shape getShape() {
        return this.shape;
    }
}

