/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.workbench;

import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.graph.TimeLagGraph;
import edu.cmu.tetradapp.model.EditorUtils;
import edu.cmu.tetradapp.workbench.DisplayEdge;
import edu.cmu.tetradapp.workbench.DisplayNode;
import edu.cmu.tetradapp.workbench.GraphNodeError;
import edu.cmu.tetradapp.workbench.GraphNodeLatent;
import edu.cmu.tetradapp.workbench.GraphNodeMeasured;
import edu.cmu.tetradapp.workbench.GraphWorkbench;
import edu.cmu.tetradapp.workbench.IDisplayEdge;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;

public class TimeLagGraphWorkbench
extends GraphWorkbench {
    private static final int MEASURED_NODE = 0;
    private static final int LATENT_NODE = 1;
    private static final int DIRECTED_EDGE = 0;
    private static final int NONDIRECTED_EDGE = 2;
    private static final int PARTIALLY_ORIENTED_EDGE = 3;
    private static final int BIDIRECTED_EDGE = 4;
    private int nodeType = 0;
    private int edgeMode = 0;
    private List<Node> rememberedNodes = new ArrayList<Node>();

    public TimeLagGraphWorkbench() {
        this(new TimeLagGraph());
    }

    public TimeLagGraphWorkbench(TimeLagGraph graph) {
        super(graph);
        this.setRightClickPopupAllowed(true);
        graph.addPropertyChangeListener(evt -> {
            if ("editingFinished".equals(evt.getPropertyName())) {
                System.out.println("EDITING FINISHED!");
                this.timeLagLayout();
            }
        });
    }

    private void timeLagLayout() {
        TimeLagGraph graph = (TimeLagGraph)this.getGraph();
        this.rememberedNodes.retainAll(graph.getNodes());
        int ySpace = 100;
        List<Node> lag0Nodes = graph.getLag0Nodes();
        System.out.println(lag0Nodes);
        int[] averageY = new int[graph.getMaxLag() + 1];
        int numRememberedLag0 = 0;
        for (Node node : lag0Nodes) {
            if (!this.rememberedNodes.contains(node)) continue;
            ++numRememberedLag0;
        }
        if (this.rememberedNodes.isEmpty() || numRememberedLag0 == 0) {
            int x = -25;
            for (Node node : lag0Nodes) {
                x += 90;
                int y = -50;
                TimeLagGraph.NodeId id = graph.getNodeId(node);
                for (int lag = graph.getMaxLag(); lag >= 0; --lag) {
                    y += 100;
                    Node _node = graph.getNode(id.getName(), lag);
                    if (_node == null) {
                        System.out.println("Couldn't find node");
                        continue;
                    }
                    _node.setCenterX(x);
                    _node.setCenterY(y);
                }
            }
        } else {
            TimeLagGraph.NodeId id;
            int lag;
            for (lag = 0; lag <= graph.getMaxLag(); ++lag) {
                for (Node node : lag0Nodes) {
                    Node _node;
                    if (!this.rememberedNodes.contains(node) || (_node = graph.getNode((id = graph.getNodeId(node)).getName(), lag)) == null) continue;
                    int n = lag;
                    averageY[n] = averageY[n] + _node.getCenterY();
                }
            }
            System.out.println("numRememberedLag0 = " + numRememberedLag0);
            for (lag = 0; lag <= graph.getMaxLag(); ++lag) {
                averageY[lag] = averageY[lag] / numRememberedLag0;
            }
            for (Node node : lag0Nodes) {
                if (this.rememberedNodes.contains(node)) continue;
                int x = node.getCenterX();
                id = graph.getNodeId(node);
                for (int lag2 = 0; lag2 <= graph.getMaxLag(); ++lag2) {
                    int y = averageY[lag2];
                    Node _node = graph.getNode(id.getName(), lag2);
                    if (_node == null) {
                        System.out.println("Couldn't find node");
                        continue;
                    }
                    _node.setCenterX(x);
                    _node.setCenterY(y);
                }
            }
        }
        this.layoutByGraph(graph);
        this.rememberedNodes = graph.getNodes();
    }

    @Override
    public int getEdgeMode() {
        return this.edgeMode;
    }

    @Override
    public Node getNewModelNode() {
        GraphNode modelNode;
        switch (this.nodeType) {
            case 0: {
                String name = this.nextVariableName("X");
                modelNode = new GraphNode(name);
                modelNode.setNodeType(NodeType.MEASURED);
                break;
            }
            case 1: {
                String name = this.nextVariableName("L");
                modelNode = new GraphNode(name);
                modelNode.setNodeType(NodeType.LATENT);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return modelNode;
    }

    @Override
    public DisplayNode getNewDisplayNode(Node modelNode) {
        DisplayNode displayNode;
        if (modelNode.getNodeType() == NodeType.MEASURED) {
            GraphNodeMeasured nodeMeasured = new GraphNodeMeasured(modelNode);
            nodeMeasured.setEditExitingMeasuredVarsAllowed(this.isEditExistingMeasuredVarsAllowed());
            displayNode = nodeMeasured;
        } else if (modelNode.getNodeType() == NodeType.LATENT) {
            displayNode = new GraphNodeLatent(modelNode);
        } else if (modelNode.getNodeType() == NodeType.ERROR) {
            displayNode = new GraphNodeError(modelNode);
        } else {
            throw new IllegalStateException();
        }
        displayNode.addPropertyChangeListener(evt -> {
            if ("resetGraph".equals(evt.getPropertyName())) {
                this.setGraph(this.getGraph());
            } else if ("editingValueChanged".equals(evt.getPropertyName())) {
                this.firePropertyChange("modelChanged", null, null);
            }
        });
        return displayNode;
    }

    @Override
    public IDisplayEdge getNewDisplayEdge(Edge modelEdge) {
        Node node2;
        Node node1 = modelEdge.getNode1();
        if (node1 == (node2 = modelEdge.getNode2())) {
            throw new IllegalArgumentException("Edges to self not supported.");
        }
        DisplayNode displayNodeA = (DisplayNode)this.getModelNodesToDisplay().get(node1);
        DisplayNode displayNodeB = (DisplayNode)this.getModelNodesToDisplay().get(node2);
        if (displayNodeA == null || displayNodeB == null) {
            return null;
        }
        return new DisplayEdge(modelEdge, displayNodeA, displayNodeB);
    }

    @Override
    public Edge getNewModelEdge(Node node1, Node node2) {
        switch (this.edgeMode) {
            case 0: {
                return Edges.directedEdge(node1, node2);
            }
            case 2: {
                return Edges.nondirectedEdge(node1, node2);
            }
            case 3: {
                return Edges.partiallyOrientedEdge(node1, node2);
            }
            case 4: {
                return Edges.bidirectedEdge(node1, node2);
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public IDisplayEdge getNewTrackingEdge(DisplayNode node, Point mouseLoc) {
        switch (this.edgeMode) {
            case 0: {
                return new DisplayEdge(node, mouseLoc, 0);
            }
            case 2: {
                return new DisplayEdge(node, mouseLoc, 1);
            }
            case 3: {
                return new DisplayEdge(node, mouseLoc, 3);
            }
            case 4: {
                return new DisplayEdge(node, mouseLoc, 4);
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public int getNodeMode() {
        return this.nodeType;
    }

    @Override
    public String nextVariableName(String base) {
        if (base.contains(":")) {
            throw new IllegalArgumentException("Base names may not contain colons: " + base);
        }
        int i = 0;
        block0: while (true) {
            String name = base + ++i;
            for (Node node1 : this.getGraph().getNodes()) {
                if (!node1.getName().equals(name)) continue;
                continue block0;
            }
            break;
        }
        return base + i;
    }

    @Override
    public void setEdgeMode(int edgeMode) {
        switch (edgeMode) {
            case 0: 
            case 2: 
            case 3: 
            case 4: {
                this.edgeMode = edgeMode;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public void setNodeType(int nodeType) {
        if (nodeType != 0 && nodeType != 1) {
            throw new IllegalArgumentException("The type of the node must be MEASURED_NODE or LATENT_NODE.");
        }
        this.nodeType = nodeType;
    }

    @Override
    public void pasteSubgraph(List graphElements, Point upperLeft) {
        Point oldUpperLeft = EditorUtils.getTopLeftPoint(graphElements);
        int deltaX = upperLeft.x - oldUpperLeft.x;
        int deltaY = upperLeft.y - oldUpperLeft.y;
        for (Object graphElement : graphElements) {
            if (graphElement instanceof Node) {
                Node node = (Node)graphElement;
                this.adjustNameAndPosition(node, deltaX, deltaY);
                this.getWorkbench().getGraph().addNode(node);
                continue;
            }
            if (graphElement instanceof Edge) {
                this.getWorkbench().getGraph().addEdge((Edge)graphElement);
                continue;
            }
            throw new IllegalArgumentException("The list of session elements should contain only SessionNodeWrappers and SessionEdges: " + graphElement);
        }
    }

    private void adjustNameAndPosition(Node node, int deltaX, int deltaY) {
        String originalName = node.getName();
        String uniqueName = this.nextUniqueName(originalName);
        if (!uniqueName.equals(originalName)) {
            node.setName(uniqueName);
            node.setCenterX(node.getCenterX() + deltaX);
            node.setCenterY(node.getCenterY() + deltaY);
        }
    }

    private String nextUniqueName(String base) {
        if (base == null) {
            throw new NullPointerException("Base name must be non-null.");
        }
        List<Node> currentNodes = this.getWorkbench().getGraph().getNodes();
        if (!TimeLagGraphWorkbench.containsName(currentNodes, base)) {
            return base;
        }
        base = base + "_";
        int i = 1;
        while (TimeLagGraphWorkbench.containsName(currentNodes, base + i)) {
            ++i;
        }
        return base + i;
    }

    private static boolean containsName(List<Node> nodes, String name) {
        for (Node node : nodes) {
            if (!name.equals(node.getName())) continue;
            return true;
        }
        return false;
    }
}

