/*
 * Decompiled with CFR 0.152.
 */
package edu.pitt.csb.mgm;

import cern.colt.matrix.DoubleMatrix2D;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphPersistence;
import edu.pitt.csb.mgm.MGM;
import edu.pitt.csb.mgm.MixedUtils;
import java.io.File;
import java.io.IOException;

public class ExampleMixedSearch {
    public static void main(String[] args) {
        try {
            String path = args[0];
            Graph trueGraph = GraphPersistence.loadGraphTxt(new File(path, "DAG_0_graph.txt"));
            DataSet data = MixedUtils.loadDataSet(path, "DAG_0_data.txt");
            double[] lambda = new double[]{0.2, 0.2, 0.2};
            double tolerance = 1.0E-7;
            int iterLimit = 1000;
            MGM model = new MGM(data, lambda);
            model.learn(1.0E-7, 1000);
            Graph mgmGraph = model.graphFromMGM();
            DoubleMatrix2D adjMat = model.adjMatFromMGM();
            System.out.println("True Graph");
            System.out.println(trueGraph);
            System.out.println("MGM Graph");
            System.out.println(mgmGraph);
            System.out.println("AdjMat");
            System.out.println(adjMat.toString());
            System.out.println("TD\tTU\tFL\tFD\tFU\tFPD\tFPU\tFND\tFNU\tBidir");
            System.out.println(MixedUtils.stringFrom2dArray(MixedUtils.allEdgeStats(trueGraph, mgmGraph)));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

