/*
 * Decompiled with CFR 0.152.
 */
package edu.pitt.csb.mgm;

import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphPersistence;
import edu.cmu.tetrad.search.IndTestMultinomialLogisticRegression;
import edu.cmu.tetrad.search.PcStable;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.util.MillisecondTimes;
import edu.pitt.csb.mgm.ExampleMixedSearch;
import edu.pitt.csb.mgm.IndTestMultinomialLogisticRegressionWald;
import edu.pitt.csb.mgm.MixedUtils;
import java.io.File;

public class ExploreIndepTests {
    public static void main(String[] args) {
        try {
            String path = ExampleMixedSearch.class.getResource("test_data").getPath();
            Graph trueGraph = SearchGraphUtils.cpdagFromDag(GraphPersistence.loadGraphTxt(new File(path, "DAG_0_graph.txt")));
            DataSet ds = MixedUtils.loadDataSet(path, "DAG_0_data.txt");
            IndTestMultinomialLogisticRegression indMix = new IndTestMultinomialLogisticRegression(ds, 0.05);
            IndTestMultinomialLogisticRegressionWald indWalLin = new IndTestMultinomialLogisticRegressionWald(ds, 0.05, true);
            IndTestMultinomialLogisticRegressionWald indWalLog = new IndTestMultinomialLogisticRegressionWald(ds, 0.05, false);
            PcStable s1 = new PcStable(indMix);
            PcStable s2 = new PcStable(indWalLin);
            PcStable s3 = new PcStable(indWalLog);
            long time = MillisecondTimes.timeMillis();
            Graph g1 = SearchGraphUtils.cpdagFromDag(s1.search());
            System.out.println("Mix Time " + (double)(MillisecondTimes.timeMillis() - time) / 1000.0);
            time = MillisecondTimes.timeMillis();
            Graph g2 = SearchGraphUtils.cpdagFromDag(s2.search());
            System.out.println("Wald lin Time " + (double)(MillisecondTimes.timeMillis() - time) / 1000.0);
            time = MillisecondTimes.timeMillis();
            Graph g3 = SearchGraphUtils.cpdagFromDag(s3.search());
            System.out.println("Wald log Time " + (double)(MillisecondTimes.timeMillis() - time) / 1000.0);
            System.out.println("TD\tTU\tFL\tFD\tFU\tFPD\tFPU\tFND\tFNU\tBidir");
            System.out.println(MixedUtils.stringFrom2dArray(MixedUtils.allEdgeStats(trueGraph, g1)));
            System.out.println(MixedUtils.stringFrom2dArray(MixedUtils.allEdgeStats(trueGraph, g2)));
            System.out.println(MixedUtils.stringFrom2dArray(MixedUtils.allEdgeStats(trueGraph, g3)));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

