/*
 * Decompiled with CFR 0.152.
 */
package edu.pitt.csb.stability;

import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.search.Fges;
import edu.cmu.tetrad.search.IndTestMultinomialLogisticRegression;
import edu.cmu.tetrad.search.PcStable;
import edu.cmu.tetrad.search.SemBicScore;
import edu.pitt.csb.mgm.MGM;
import edu.pitt.csb.mgm.MixedUtils;
import edu.pitt.csb.stability.DataGraphSearch;

public class SearchWrappers {

    public static class FgesWrapper
    extends DataGraphSearch {
        public FgesWrapper(double ... params) {
            super(params);
        }

        @Override
        public FgesWrapper copy() {
            return new FgesWrapper(this.searchParams);
        }

        @Override
        public Graph search(DataSet ds) {
            SemBicScore score = new SemBicScore(new CovarianceMatrix(MixedUtils.makeContinuousData(ds)));
            score.setPenaltyDiscount(this.searchParams[0]);
            Fges fg = new Fges(score);
            return fg.search();
        }
    }

    public static class MGMWrapper
    extends DataGraphSearch {
        public MGMWrapper(double ... params) {
            super(params);
        }

        @Override
        public MGMWrapper copy() {
            return new MGMWrapper(this.searchParams);
        }

        @Override
        public Graph search(DataSet ds) {
            MGM m = new MGM(ds, this.searchParams);
            return m.search();
        }
    }

    public static class PcStableWrapper
    extends DataGraphSearch {
        public PcStableWrapper(double ... params) {
            super(params);
        }

        @Override
        public PcStableWrapper copy() {
            return new PcStableWrapper(this.searchParams);
        }

        @Override
        public Graph search(DataSet ds) {
            IndTestMultinomialLogisticRegression indTest = new IndTestMultinomialLogisticRegression(ds, this.searchParams[0]);
            PcStable pcs = new PcStable(indTest);
            return pcs.search();
        }
    }
}

