/*
 * Decompiled with CFR 0.152.
 */
package edu.pitt.dbmi.algo.bayesian.constraint.inference;

import java.util.Arrays;
import org.apache.commons.math3.util.FastMath;

public class BCInference {
    private static final int MININUM_EXPONENT = -1022;
    private double priorEquivalentSampleSize = 1.0;
    private int[] countsTree;
    private int[] counts;
    private final double[] logfact;
    private int[][] parents;
    private final int maxCases;
    private final int maxNodes;
    private int maxParents;
    private int maxCells;
    private int countsTreePtr;
    private int countsPtr;
    private int numberOfNodes;
    private final int numberOfCases;
    private final int[][] cases;
    private final int[] nodeDimension;
    private final int scoreFn;
    private final double[][] scores;
    private int numberOfScores;

    public BCInference(int[][] cases, int[] nodeDimension) {
        this.cases = cases;
        this.nodeDimension = nodeDimension;
        this.numberOfNodes = nodeDimension.length - 2;
        this.maxCases = this.numberOfCases = cases.length - 1;
        this.maxNodes = this.numberOfNodes;
        int maxValues = this.findMaxValue(nodeDimension);
        int maxLogFact = 2 * this.maxCases + maxValues;
        this.scoreFn = 1;
        this.logfact = new double[maxLogFact + 1];
        int[] _nodeDimension = Arrays.copyOf(nodeDimension, nodeDimension.length);
        Arrays.sort(_nodeDimension);
        int g1 = _nodeDimension[_nodeDimension.length - 1];
        int g2 = _nodeDimension[_nodeDimension.length - 2];
        this.maxCells = this.maxParents * g1 * g2 * this.maxCases;
        this.parents = new int[this.maxNodes + 2][this.maxParents + 1];
        this.countsTree = new int[this.maxCells + 1];
        this.counts = new int[this.maxCells + 1];
        this.scores = new double[this.maxCases + 1][4];
    }

    public synchronized double probConstraint(OP constraint, int x, int y, int[] z) {
        int n;
        double p = 0.0;
        this.logfact[0] = 0.0;
        for (int i = 1; i < this.logfact.length; ++i) {
            this.logfact[i] = FastMath.log(i) + this.logfact[i - 1];
        }
        this.logfact[0] = 0.0;
        if (z.length > this.maxParents) {
            this.maxParents = z.length;
            int[] _nodeDimension = Arrays.copyOf(this.nodeDimension, this.nodeDimension.length);
            Arrays.sort(_nodeDimension);
            int g1 = _nodeDimension[_nodeDimension.length - 1];
            int g2 = _nodeDimension[_nodeDimension.length - 2];
            this.maxCells = this.maxParents * g1 * g2 * this.maxCases;
            this.parents = new int[this.maxNodes + 2][this.maxParents + 1];
            this.countsTree = new int[this.maxCells + 1];
            this.counts = new int[this.maxCells + 1];
        }
        this.parents[x][0] = n = z[0];
        if (n >= 0) {
            System.arraycopy(z, 1, this.parents[x], 1, n);
        }
        double lnMarginalLikelihood_X = this.scoreNode(x, 1);
        this.parents[y][0] = n;
        if (n >= 0) {
            System.arraycopy(z, 1, this.parents[y], 1, n);
        }
        double lnMarginalLikelihood_Y = this.scoreNode(y, 2);
        double lnMarginalLikelihood_X_Y = lnMarginalLikelihood_X + lnMarginalLikelihood_Y;
        p = this.priorIndependent(x, y, z);
        double lnPrior_X_Y = FastMath.log(p);
        double score_X_Y = lnMarginalLikelihood_X_Y + lnPrior_X_Y;
        ++this.numberOfNodes;
        int xy = this.numberOfNodes;
        for (int casei = 1; casei <= this.numberOfCases; ++casei) {
            int xValue = this.cases[casei][x];
            int yValue = this.cases[casei][y];
            if (y >= this.nodeDimension.length) {
                System.out.println("y:" + y + " nodeDimension:" + this.nodeDimension.length);
            }
            if (casei >= this.cases.length) {
                System.out.println("casei:" + casei + " cases:" + this.cases.length);
            }
            if (xy >= this.cases[casei].length) {
                System.out.println("xy:" + xy + " cases[casei]:" + this.cases[casei].length);
            }
            this.cases[casei][xy] = (xValue - 1) * this.nodeDimension[y] + yValue;
        }
        this.nodeDimension[xy] = this.nodeDimension[x] * this.nodeDimension[y];
        this.parents[xy][0] = n;
        if (n >= 0) {
            System.arraycopy(z, 1, this.parents[xy], 1, n);
        }
        double lnMarginalLikelihood_XY = this.scoreNode(xy, 3);
        --this.numberOfNodes;
        double lnTermPrior_X_Y = FastMath.log(p) / (double)this.numberOfScores;
        double lnTermPrior_XY = FastMath.log(1.0 - FastMath.exp(lnTermPrior_X_Y));
        double scoreAll = 0.0;
        for (int i = 1; i <= this.numberOfScores; ++i) {
            scoreAll += this.lnXpluslnY(lnTermPrior_X_Y + (this.scores[i][1] + this.scores[i][2]), lnTermPrior_XY + this.scores[i][3]);
        }
        double probInd = FastMath.exp(score_X_Y - scoreAll);
        p = constraint == OP.independent ? probInd : 1.0 - probInd;
        return p;
    }

    protected double lnXpluslnY(double lnX, double lnY) {
        double lnYminusLnX;
        if (lnY > lnX) {
            double temp = lnX;
            lnX = lnY;
            lnY = temp;
        }
        if ((lnYminusLnX = lnY - lnX) < -1022.0) {
            return lnX;
        }
        return FastMath.log1p(FastMath.exp(lnYminusLnX)) + lnX;
    }

    private double priorIndependent(int x, int y, int[] z) {
        return 0.5;
    }

    private double scoreNode(int node, int whichList) {
        double totalScore = 0.0;
        if (this.parents[node][0] > 0) {
            int firstParentSize = this.nodeDimension[this.parents[node][1]];
            for (int i = 1; i <= firstParentSize; ++i) {
                this.countsTree[i] = 0;
            }
            this.countsTreePtr = firstParentSize + 1;
            this.countsPtr = 1;
        } else {
            this.countsTreePtr = 1;
            this.countsPtr = this.nodeDimension[node] + 1;
            for (int i = 1; i <= this.nodeDimension[node]; ++i) {
                this.counts[i] = 0;
            }
        }
        for (int casei = 1; casei <= this.numberOfCases; ++casei) {
            this.fileCase(node, casei);
        }
        int instancePtr = 1;
        int q = 1;
        for (int i = 1; i <= this.parents[node][0]; ++i) {
            q *= this.nodeDimension[this.parents[node][i]];
        }
        this.numberOfScores = 0;
        while (instancePtr < this.countsPtr) {
            double score = this.scoreFn == 1 ? this.scoringFn1(node, instancePtr, q, this.priorEquivalentSampleSize) : this.scoringFn2(node, instancePtr);
            ++this.numberOfScores;
            this.scores[this.numberOfScores][whichList] = score;
            totalScore += score;
            instancePtr += this.nodeDimension[node];
        }
        return totalScore;
    }

    private double scoreNode(int node) {
        double score = 0.0;
        if (this.parents[node][0] > 0) {
            int firstParentSize = this.nodeDimension[this.parents[node][1]];
            for (int i = 1; i <= firstParentSize; ++i) {
                this.countsTree[i] = 0;
            }
            this.countsTreePtr = firstParentSize + 1;
            this.countsPtr = 1;
        } else {
            this.countsTreePtr = 1;
            this.countsPtr = this.nodeDimension[node] + 1;
            for (int i = 1; i <= this.nodeDimension[node]; ++i) {
                this.counts[i] = 0;
            }
        }
        for (int casei = 1; casei <= this.numberOfCases; ++casei) {
            this.fileCase(node, casei);
        }
        score = 0.0;
        for (int instancePtr = 1; instancePtr < this.countsPtr; instancePtr += this.nodeDimension[node]) {
            score += this.scoringFn2(node, instancePtr);
        }
        return score;
    }

    private double scoringFn1(int node, int instancePtr, double q, double pess) {
        int Nij = 0;
        double scoreOfSum = 0.0;
        int r = this.nodeDimension[node];
        double pessDivQR = pess / (q * (double)r);
        double pessDivQ = pess / q;
        double lngammPessDivQR = this.gammln(pessDivQR);
        for (int k = 0; k <= r - 1; ++k) {
            int Nijk = this.counts[instancePtr + k];
            Nij += Nijk;
            scoreOfSum += this.gammln((double)Nijk + pessDivQR) - lngammPessDivQR;
        }
        return this.gammln(pessDivQ) - this.gammln((double)Nij + pessDivQ) + scoreOfSum;
    }

    private double gammln(double xx) {
        if (xx == 1.0) {
            return 0.0;
        }
        if (xx > 1.0) {
            return this.gammlnCore(xx);
        }
        double z = 1.0 - xx;
        return FastMath.log(Math.PI * z) - this.gammlnCore(1.0 + z) - FastMath.log(FastMath.sin(Math.PI * z));
    }

    private double gammlnCore(double xx) {
        double stp = 2.50662827465;
        double half = 0.5;
        double one = 1.0;
        double fpf = 5.5;
        double[] cof = new double[]{0.0, 76.18009173, -86.50532033, 24.01409822, -1.231739516, 0.00120858003, -5.36382E-6};
        double x = xx - 1.0;
        double tmp = x + 5.5;
        tmp = (x + 0.5) * FastMath.log(tmp) - tmp;
        double ser = 1.0;
        for (int j = 1; j <= 6; ++j) {
            ser += cof[j] / (x += 1.0);
        }
        return tmp + FastMath.log(2.50662827465 * ser);
    }

    private double scoringFn2(int node, int instancePtr) {
        int hits = 0;
        double scoreNI = 0.0;
        for (int i = 0; i <= this.nodeDimension[node] - 1; ++i) {
            int count = this.counts[instancePtr + i];
            hits += count;
            scoreNI += this.logfact[count];
        }
        return scoreNI += this.logfact[this.nodeDimension[node] - 1] - this.logfact[hits + this.nodeDimension[node] - 1];
    }

    private void fileCase(int node, int casei) {
        int i;
        int parent = 0;
        int parentValue = 0;
        int cPtr = 0;
        int parenti = 0;
        int nodeValue = this.cases[casei][node];
        if (nodeValue == 0) {
            throw new IllegalArgumentException();
        }
        int numberOfParents = this.parents[node][0];
        boolean missingValue = false;
        for (int i2 = 1; i2 <= numberOfParents; ++i2) {
            parent = this.parents[node][i2];
            parentValue = this.cases[casei][parent];
            if (parentValue != 0) continue;
            throw new IllegalArgumentException();
        }
        int ctPtr = 1;
        int ptr = 1;
        for (i = 1; i <= numberOfParents; ++i) {
            parent = this.parents[node][i];
            parentValue = this.cases[casei][parent];
            ptr = this.countsTree[ctPtr + parentValue - 1];
            if (ptr <= 0) {
                parenti = i;
                break;
            }
            ctPtr = ptr;
        }
        if (ptr > 0) {
            cPtr = ctPtr;
        } else {
            for (i = parenti; i <= numberOfParents; ++i) {
                parent = this.parents[node][i];
                parentValue = this.cases[casei][parent];
                if (i == numberOfParents) {
                    this.countsTree[ctPtr + parentValue - 1] = this.countsPtr;
                    continue;
                }
                this.countsTree[ctPtr + parentValue - 1] = this.countsTreePtr;
                for (int j = this.countsTreePtr; j <= this.countsTreePtr + this.nodeDimension[this.parents[node][i + 1]] - 1; ++j) {
                    this.countsTree[j] = 0;
                }
                ctPtr = this.countsTreePtr;
                this.countsTreePtr += this.nodeDimension[this.parents[node][i + 1]];
                if (this.countsPtr <= this.maxCells) continue;
                System.out.println(this.maxCells);
                System.out.println(this.countsTreePtr);
                System.out.println(ctPtr);
                System.out.println(this.countsPtr);
                System.out.println(this.nodeDimension[this.parents[node][i + 1]]);
                throw new IllegalArgumentException();
            }
            if (this.countsPtr > this.maxCells) {
                System.out.println(this.maxCells);
                System.out.println(this.countsTreePtr);
                System.out.println(ctPtr);
                System.out.println(this.countsPtr);
                System.out.println(node);
                System.out.println(this.nodeDimension[node]);
                throw new IllegalArgumentException();
            }
            for (int j = this.countsPtr; j <= this.countsPtr + this.nodeDimension[node] - 1; ++j) {
                this.counts[j] = 0;
            }
            cPtr = this.countsPtr;
            this.countsPtr += this.nodeDimension[node];
            if (this.countsPtr > this.maxCells) {
                System.out.println(this.maxCells);
                System.out.println(this.countsTreePtr);
                System.out.println(ctPtr);
                System.out.println("Max nodes = " + this.maxNodes);
                System.out.println("Node = " + node);
                System.out.println(this.nodeDimension[node]);
                throw new IllegalArgumentException();
            }
        }
        int n = cPtr + nodeValue - 1;
        this.counts[n] = this.counts[n] + 1;
    }

    private int findMaxValue(int[] nodeDimension) {
        int maxValue = 0;
        for (int i = 1; i < nodeDimension.length; ++i) {
            if (maxValue >= nodeDimension[i]) continue;
            maxValue = nodeDimension[i];
        }
        return maxValue;
    }

    public void setPriorEqivalentSampleSize(double priorEquivalentSampleSize) {
        this.priorEquivalentSampleSize = priorEquivalentSampleSize;
    }

    public static enum OP {
        independent,
        dependent;

    }
}

