/*
 * Decompiled with CFR 0.152.
 */
package edu.pitt.dbmi.algo.bayesian.constraint.search;

import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.search.GraphSearch;
import edu.cmu.tetrad.search.IndTestProbabilistic;
import edu.cmu.tetrad.search.Rfci;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.util.GraphTools;
import edu.pitt.dbmi.algo.resampling.ResamplingEdgeEnsemble;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class PagSamplingRfci
implements GraphSearch {
    private final int NUM_THREADS = 10;
    private int numRandomizedSearchModels = 10;
    private int edgeEnsemble = 2;
    private boolean verbose = false;
    private int depth = -1;
    private int maxPathLength = -1;
    private boolean threshold = true;
    private double cutoff = 0.5;
    private double priorEquivalentSampleSize = 10.0;
    private Knowledge knowledge;
    private final DataSet dataSet;

    public PagSamplingRfci(DataSet dataSet) {
        this.dataSet = dataSet;
    }

    @Override
    public Graph search() {
        List<Graph> graphs = this.runSearches();
        ResamplingEdgeEnsemble edgeEnsemble = this.getEdgeEnsemble(this.edgeEnsemble);
        return GraphTools.createHighEdgeProbabilityGraph(graphs, edgeEnsemble);
    }

    private ResamplingEdgeEnsemble getEdgeEnsemble(int edgeEnsemble) {
        switch (edgeEnsemble) {
            case 1: {
                return ResamplingEdgeEnsemble.Preserved;
            }
            case 2: {
                return ResamplingEdgeEnsemble.Highest;
            }
            case 3: {
                return ResamplingEdgeEnsemble.Majority;
            }
        }
        throw new IllegalArgumentException("Unknow edge ensemble = " + edgeEnsemble);
    }

    List<Callable<Graph>> createTasks(int numOfTasks) {
        LinkedList<Callable<Graph>> callableTasks = new LinkedList<Callable<Graph>>();
        for (int i = 0; i < numOfTasks; ++i) {
            callableTasks.add(new RfciSearchTask());
        }
        return callableTasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Graph> runSearches() {
        LinkedList<Graph> graphs = new LinkedList<Graph>();
        ExecutorService pool = Executors.newFixedThreadPool(10);
        try {
            while (graphs.size() < this.numRandomizedSearchModels && !Thread.currentThread().isInterrupted()) {
                List<Callable<Graph>> callableTasks = this.createTasks(this.numRandomizedSearchModels - graphs.size());
                List<Future<Graph>> completedTasks = pool.invokeAll(callableTasks);
                for (Future<Graph> completedTask : completedTasks) {
                    try {
                        Graph graph = completedTask.get();
                        if (graph == null || !SearchGraphUtils.isLegalPag(graph).isLegalPag()) continue;
                        graphs.add(graph);
                    }
                    catch (ExecutionException exception) {
                        exception.printStackTrace(System.err);
                    }
                }
            }
        }
        catch (InterruptedException exception) {
            exception.printStackTrace(System.err);
        }
        finally {
            this.shutdownAndAwaitTermination(pool);
        }
        return graphs;
    }

    private void shutdownAndAwaitTermination(ExecutorService pool) {
        pool.shutdown();
        try {
            if (!pool.awaitTermination(5L, TimeUnit.SECONDS)) {
                pool.shutdownNow();
                if (!pool.awaitTermination(5L, TimeUnit.SECONDS)) {
                    System.err.println("Pool did not terminate");
                }
            }
        }
        catch (InterruptedException ie) {
            pool.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public void setNumRandomizedSearchModels(int numRandomizedSearchModels) {
        this.numRandomizedSearchModels = numRandomizedSearchModels;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public void setMaxPathLength(int maxPathLength) {
        this.maxPathLength = maxPathLength;
    }

    public void setThreshold(boolean threshold) {
        this.threshold = threshold;
    }

    public void setCutoff(double cutoff) {
        this.cutoff = cutoff;
    }

    public void setPriorEquivalentSampleSize(double priorEquivalentSampleSize) {
        this.priorEquivalentSampleSize = priorEquivalentSampleSize;
    }

    public void setEdgeEnsemble(int edgeEnsemble) {
        this.edgeEnsemble = edgeEnsemble;
    }

    public void setKnowledge(Knowledge knowledge) {
        this.knowledge = knowledge;
    }

    private class RfciSearchTask
    implements Callable<Graph> {
        @Override
        public Graph call() throws Exception {
            try {
                IndTestProbabilistic independenceTest = new IndTestProbabilistic(PagSamplingRfci.this.dataSet);
                independenceTest.setThreshold(PagSamplingRfci.this.threshold);
                independenceTest.setCutoff(PagSamplingRfci.this.cutoff);
                independenceTest.setPriorEquivalentSampleSize(PagSamplingRfci.this.priorEquivalentSampleSize);
                independenceTest.setVerbose(PagSamplingRfci.this.verbose);
                Rfci rfci = new Rfci(independenceTest);
                if (PagSamplingRfci.this.knowledge != null) {
                    rfci.setKnowledge(PagSamplingRfci.this.knowledge);
                }
                rfci.setDepth(PagSamplingRfci.this.depth);
                rfci.setMaxPathLength(PagSamplingRfci.this.maxPathLength);
                rfci.setVerbose(PagSamplingRfci.this.verbose);
                return rfci.search();
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
                return null;
            }
        }
    }
}

