/*
 * Decompiled with CFR 0.152.
 */
package edu.pitt.dbmi.algo.resampling;

import edu.cmu.tetrad.algcomparison.algorithm.Algorithm;
import edu.cmu.tetrad.algcomparison.algorithm.MultiDataSetAlgorithm;
import edu.cmu.tetrad.algcomparison.score.ScoreWrapper;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataUtils;
import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.util.Parameters;
import edu.pitt.dbmi.algo.resampling.task.GeneralResamplingSearchRunnable;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ForkJoinPool;
import org.apache.commons.math3.random.SynchronizedRandomGenerator;
import org.apache.commons.math3.random.Well44497b;

public class GeneralResamplingSearch {
    private final int numberResampling;
    private final List<Graph> graphs = Collections.synchronizedList(new ArrayList());
    private final ForkJoinPool pool;
    private Algorithm algorithm;
    private MultiDataSetAlgorithm multiDataSetAlgorithm;
    private double percentResampleSize = 100.0;
    private boolean resamplingWithReplacement = true;
    private boolean runParallel;
    private boolean addOriginalDataset;
    private boolean verbose;
    private DataSet data;
    private List<DataSet> dataSets;
    private Knowledge knowledge = new Knowledge();
    private PrintStream out = System.out;
    private Parameters parameters;
    private Graph externalGraph;
    private int numNograph = 0;
    private ScoreWrapper scoreWrapper;

    public GeneralResamplingSearch(DataSet data, int numberResampling) {
        this.data = data;
        this.pool = ForkJoinPool.commonPool();
        this.numberResampling = numberResampling;
    }

    public GeneralResamplingSearch(List<DataSet> dataSets, int numberResampling) {
        this.dataSets = dataSets;
        this.pool = ForkJoinPool.commonPool();
        this.numberResampling = numberResampling;
    }

    public void setAlgorithm(Algorithm algorithm) {
        this.algorithm = algorithm;
        this.multiDataSetAlgorithm = null;
    }

    public void setMultiDataSetAlgorithm(MultiDataSetAlgorithm multiDataSetAlgorithm) {
        this.multiDataSetAlgorithm = multiDataSetAlgorithm;
        this.algorithm = null;
    }

    public void setPercentResampleSize(double percentResampleSize) {
        this.percentResampleSize = percentResampleSize;
    }

    public void setResamplingWithReplacement(boolean resamplingWithReplacement) {
        this.resamplingWithReplacement = resamplingWithReplacement;
    }

    public void setRunParallel(boolean runParallel) {
        this.runParallel = runParallel;
    }

    public void setAddOriginalDataset(boolean addOriginalDataset) {
        this.addOriginalDataset = addOriginalDataset;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setData(DataSet data) {
        this.data = data;
    }

    public void setKnowledge(Knowledge knowledge) {
        this.knowledge = new Knowledge(knowledge);
    }

    public void setExternalGraph(Graph externalGraph) {
        this.externalGraph = externalGraph;
    }

    public PrintStream getOut() {
        return this.out;
    }

    public void setOut(PrintStream out) {
        this.out = out;
    }

    public void setParameters(Parameters parameters) {
        this.parameters = parameters;
    }

    /*
     * WARNING - void declaration
     */
    public List<Graph> search() {
        this.graphs.clear();
        this.parameters.set("numberResampling", (Object)0);
        ArrayList<GeneralResamplingSearchRunnable> tasks = new ArrayList<GeneralResamplingSearchRunnable>();
        if (this.verbose) {
            this.out.println("Running Resamplings in Sequential Mode, numberResampling = " + this.numberResampling);
        }
        if (this.data != null) {
            void var4_7;
            Long seed = this.parameters == null || this.parameters.get("seed") == null ? null : (Long)this.parameters.get("seed");
            SynchronizedRandomGenerator randomGenerator = seed == null || seed < 0L ? null : new SynchronizedRandomGenerator(new Well44497b(seed));
            boolean bl = false;
            while (var4_7 < this.numberResampling) {
                DataSet dataSet = this.resamplingWithReplacement ? (randomGenerator == null ? DataUtils.getBootstrapSample(this.data, (int)((double)this.data.getNumRows() * this.percentResampleSize / 100.0)) : DataUtils.getBootstrapSample(this.data, (int)((double)this.data.getNumRows() * this.percentResampleSize / 100.0), randomGenerator)) : (randomGenerator == null ? DataUtils.getResamplingDataset(this.data, (int)((double)this.data.getNumRows() * this.percentResampleSize / 100.0)) : DataUtils.getResamplingDataset(this.data, (int)((double)this.data.getNumRows() * this.percentResampleSize / 100.0), randomGenerator));
                dataSet.setKnowledge(this.data.getKnowledge());
                GeneralResamplingSearchRunnable task = new GeneralResamplingSearchRunnable(dataSet, this.algorithm, this.parameters, this, this.verbose);
                task.setExternalGraph(this.externalGraph);
                task.setKnowledge(this.knowledge);
                tasks.add(task);
                task.setScoreWrapper(this.scoreWrapper);
                ++var4_7;
            }
            if (this.addOriginalDataset) {
                GeneralResamplingSearchRunnable generalResamplingSearchRunnable = new GeneralResamplingSearchRunnable(this.data.copy(), this.algorithm, this.parameters, this, this.verbose);
                generalResamplingSearchRunnable.setExternalGraph(this.externalGraph);
                generalResamplingSearchRunnable.setKnowledge(this.knowledge);
                tasks.add(generalResamplingSearchRunnable);
                generalResamplingSearchRunnable.setScoreWrapper(this.scoreWrapper);
            }
        } else {
            for (int i1 = 0; i1 < this.numberResampling; ++i1) {
                ArrayList<DataModel> dataModels = new ArrayList<DataModel>();
                for (DataSet data : this.dataSets) {
                    if (this.resamplingWithReplacement) {
                        DataSet bootstrapSample = DataUtils.getBootstrapSample(data, (int)((double)data.getNumRows() * this.percentResampleSize / 100.0));
                        bootstrapSample.setKnowledge(data.getKnowledge());
                        dataModels.add(bootstrapSample);
                        continue;
                    }
                    DataSet resamplingDataset = DataUtils.getResamplingDataset(data, (int)((double)data.getNumRows() * this.percentResampleSize / 100.0));
                    resamplingDataset.setKnowledge(data.getKnowledge());
                    dataModels.add(resamplingDataset);
                }
                GeneralResamplingSearchRunnable generalResamplingSearchRunnable = new GeneralResamplingSearchRunnable(dataModels, this.multiDataSetAlgorithm, this.parameters, this, this.verbose);
                generalResamplingSearchRunnable.setExternalGraph(this.externalGraph);
                generalResamplingSearchRunnable.setKnowledge(((DataModel)dataModels.get(0)).getKnowledge());
                generalResamplingSearchRunnable.setScoreWrapper(this.scoreWrapper);
                tasks.add(generalResamplingSearchRunnable);
            }
        }
        int numNoGraph = 0;
        for (Callable callable : tasks) {
            try {
                Graph graph = (Graph)callable.call();
                if (graph == null) {
                    ++numNoGraph;
                    continue;
                }
                this.graphs.add(graph);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.parameters.set("numberResampling", (Object)this.numberResampling);
        this.numNograph = numNoGraph;
        return this.graphs;
    }

    public int getNumNograph() {
        return this.numNograph;
    }

    public void setScoreWrapper(ScoreWrapper scoreWrapper) {
        this.scoreWrapper = scoreWrapper;
    }
}

