/*
 * Decompiled with CFR 0.152.
 */
package edu.pitt.dbmi.data.reader;

import edu.pitt.dbmi.data.reader.DataReader;
import edu.pitt.dbmi.data.reader.Delimiter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;

public abstract class DataFileReader
implements DataReader {
    protected static final int BUFFER_SIZE = 0x100000;
    protected static final byte LINE_FEED = 10;
    protected static final byte CARRIAGE_RETURN = 13;
    protected static final byte SPACE_CHAR = Delimiter.SPACE.getByteValue();
    protected byte quoteCharacter;
    protected String commentMarker;
    protected final Path dataFile;
    protected final Delimiter delimiter;

    public DataFileReader(Path dataFile, Delimiter delimiter) {
        this.dataFile = dataFile;
        this.delimiter = delimiter;
        this.quoteCharacter = (byte)-1;
        this.commentMarker = "";
    }

    protected int countNumberOfColumns() throws IOException {
        int count = 0;
        try (InputStream in = Files.newInputStream(this.dataFile, StandardOpenOption.READ);){
            int len;
            boolean skip = false;
            boolean hasSeenNonblankChar = false;
            boolean hasQuoteChar = false;
            boolean finished = false;
            byte delimChar = this.delimiter.getByteValue();
            byte prevChar = -1;
            byte[] comment = this.commentMarker.getBytes();
            int cmntIndex = 0;
            boolean checkForComment = comment.length > 0;
            byte[] buffer = new byte[0x100000];
            while ((len = in.read(buffer)) != -1 && !finished && !Thread.currentThread().isInterrupted()) {
                for (int i = 0; i < len && !finished && !Thread.currentThread().isInterrupted(); ++i) {
                    byte currChar = buffer[i];
                    if (currChar == 13 || currChar == 10) {
                        boolean bl = finished = hasSeenNonblankChar && !skip;
                        if (finished) {
                            ++count;
                        }
                        skip = false;
                        hasSeenNonblankChar = false;
                        cmntIndex = 0;
                        checkForComment = comment.length > 0;
                    } else if (!skip) {
                        if (currChar > SPACE_CHAR) {
                            hasSeenNonblankChar = true;
                        }
                        if (currChar <= SPACE_CHAR && !hasSeenNonblankChar) continue;
                        if (checkForComment) {
                            if (currChar == comment[cmntIndex]) {
                                if (++cmntIndex == comment.length) {
                                    skip = true;
                                    prevChar = currChar;
                                    continue;
                                }
                            } else {
                                checkForComment = false;
                            }
                        }
                        if (currChar == this.quoteCharacter) {
                            hasQuoteChar = !hasQuoteChar;
                        } else if (!hasQuoteChar) {
                            if (this.delimiter == Delimiter.WHITESPACE) {
                                if (currChar <= SPACE_CHAR && prevChar > SPACE_CHAR) {
                                    ++count;
                                }
                            } else if (currChar == delimChar) {
                                ++count;
                            }
                        }
                    }
                    prevChar = currChar;
                }
            }
            boolean bl = finished = hasSeenNonblankChar && !skip;
            if (finished) {
                ++count;
            }
        }
        return count;
    }

    protected int countNumberOfLines() throws IOException {
        int count = 0;
        try (InputStream in = Files.newInputStream(this.dataFile, StandardOpenOption.READ);){
            int len;
            boolean skip = false;
            boolean hasSeenNonblankChar = false;
            byte[] comment = this.commentMarker.getBytes();
            int cmntIndex = 0;
            boolean checkForComment = comment.length > 0;
            byte[] buffer = new byte[0x100000];
            while ((len = in.read(buffer)) != -1 && !Thread.currentThread().isInterrupted()) {
                for (int i = 0; i < len; ++i) {
                    byte currChar = buffer[i];
                    if (currChar == 13 || currChar == 10) {
                        if (!skip && cmntIndex > 0) {
                            ++count;
                        }
                        skip = false;
                        hasSeenNonblankChar = false;
                        cmntIndex = 0;
                        continue;
                    }
                    if (skip) continue;
                    if (currChar > SPACE_CHAR) {
                        hasSeenNonblankChar = true;
                    }
                    if (currChar <= SPACE_CHAR && !hasSeenNonblankChar) continue;
                    if (checkForComment && currChar == comment[cmntIndex]) {
                        if (++cmntIndex != comment.length) continue;
                        skip = true;
                        continue;
                    }
                    ++count;
                    skip = true;
                }
            }
            if (!skip && cmntIndex > 0) {
                ++count;
            }
        }
        return count;
    }

    @Override
    public void setQuoteCharacter(char quoteCharacter) {
        this.quoteCharacter = Character.isDefined(quoteCharacter) ? (int)quoteCharacter : -1;
    }

    @Override
    public void setCommentMarker(String commentMarker) {
        this.commentMarker = commentMarker == null ? "" : commentMarker.trim();
    }
}

