/*
 * Decompiled with CFR 0.152.
 */
package edu.pitt.dbmi.data.reader.tabular;

import edu.pitt.dbmi.data.reader.ContinuousData;
import edu.pitt.dbmi.data.reader.Data;
import edu.pitt.dbmi.data.reader.DataColumn;
import edu.pitt.dbmi.data.reader.DatasetFileReader;
import edu.pitt.dbmi.data.reader.Delimiter;
import edu.pitt.dbmi.data.reader.DiscreteData;
import edu.pitt.dbmi.data.reader.DiscreteDataColumn;
import edu.pitt.dbmi.data.reader.tabular.MixedTabularData;
import edu.pitt.dbmi.data.reader.tabular.MixedTabularDataColumn;
import edu.pitt.dbmi.data.reader.tabular.MixedTabularDatasetReader;
import edu.pitt.dbmi.data.reader.tabular.TabularColumnFileReader;
import edu.pitt.dbmi.data.reader.tabular.TabularDataFileReader;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;

public class MixedTabularDatasetFileReader
extends DatasetFileReader
implements MixedTabularDatasetReader {
    private final int numberOfDiscreteCategories;
    private boolean hasHeader;
    private char quoteChar;

    public MixedTabularDatasetFileReader(Path dataFile, Delimiter delimiter, int numberOfDiscreteCategories) {
        super(dataFile, delimiter);
        this.numberOfDiscreteCategories = numberOfDiscreteCategories;
        this.hasHeader = true;
        this.quoteChar = (char)34;
    }

    @Override
    public Data readInData() throws IOException {
        return this.readInData(Collections.EMPTY_SET);
    }

    @Override
    public Data readInData(Set<String> namesOfColumnsToExclude) throws IOException {
        TabularColumnFileReader columnReader = new TabularColumnFileReader(this.dataFile, this.delimiter);
        columnReader.setCommentMarker(this.commentMarker);
        columnReader.setQuoteCharacter(this.quoteChar);
        boolean isDiscrete = false;
        DataColumn[] dataColumns = this.hasHeader ? columnReader.readInDataColumns(namesOfColumnsToExclude, false) : columnReader.generateColumns(new int[0], false);
        TabularDataFileReader dataReader = new TabularDataFileReader(this.dataFile, this.delimiter);
        dataReader.setCommentMarker(this.commentMarker);
        dataReader.setQuoteCharacter(this.quoteChar);
        dataReader.setMissingDataMarker(this.missingDataMarker);
        dataReader.determineDiscreteDataColumns(dataColumns, this.numberOfDiscreteCategories, this.hasHeader);
        return this.toMixedData(dataReader.read(dataColumns, this.hasHeader));
    }

    @Override
    public Data readInData(int[] columnsToExclude) throws IOException {
        TabularColumnFileReader columnReader = new TabularColumnFileReader(this.dataFile, this.delimiter);
        columnReader.setCommentMarker(this.commentMarker);
        columnReader.setQuoteCharacter(this.quoteChar);
        boolean isDiscrete = false;
        DataColumn[] dataColumns = this.hasHeader ? columnReader.readInDataColumns(columnsToExclude, false) : columnReader.generateColumns(columnsToExclude, false);
        TabularDataFileReader dataReader = new TabularDataFileReader(this.dataFile, this.delimiter);
        dataReader.setCommentMarker(this.commentMarker);
        dataReader.setQuoteCharacter(this.quoteChar);
        dataReader.setMissingDataMarker(this.missingDataMarker);
        dataReader.determineDiscreteDataColumns(dataColumns, this.numberOfDiscreteCategories, this.hasHeader);
        return this.toMixedData(dataReader.read(dataColumns, this.hasHeader));
    }

    private Data toMixedData(Data data) {
        if (data instanceof ContinuousData) {
            ContinuousData continuousData = (ContinuousData)data;
            double[][] contData = continuousData.getData();
            int numOfRows = contData.length;
            int numOfCols = contData[0].length;
            DiscreteDataColumn[] columns = (DiscreteDataColumn[])Arrays.stream(continuousData.getDataColumns()).map(MixedTabularDataColumn::new).toArray(DiscreteDataColumn[]::new);
            double[][] vertContData = new double[numOfCols][numOfRows];
            for (int row = 0; row < numOfRows; ++row) {
                for (int col = 0; col < numOfCols; ++col) {
                    vertContData[col][row] = contData[row][col];
                }
            }
            return new MixedTabularData(numOfRows, columns, vertContData, new int[0][0]);
        }
        if (data instanceof DiscreteData) {
            DiscreteData verticalDiscreteData = (DiscreteData)data;
            int[][] discreteData = verticalDiscreteData.getData();
            int numOfRows = discreteData[0].length;
            DiscreteDataColumn[] columns = (DiscreteDataColumn[])Arrays.stream(verticalDiscreteData.getDataColumns()).map(e -> {
                MixedTabularDataColumn column = new MixedTabularDataColumn(e.getDataColumn());
                e.getCategories().forEach(v -> column.setValue((String)v));
                e.recategorize();
                return column;
            }).toArray(DiscreteDataColumn[]::new);
            return new MixedTabularData(numOfRows, columns, new double[0][0], discreteData);
        }
        if (data instanceof MixedTabularData) {
            MixedTabularData mixedTabularData = (MixedTabularData)data;
            DiscreteDataColumn[] columns = mixedTabularData.getDataColumns();
            double[][] continuousData = mixedTabularData.getContinuousData();
            int[][] discreteData = mixedTabularData.getDiscreteData();
            int numOfRows = mixedTabularData.getNumOfRows();
            return new MixedTabularData(numOfRows, columns, continuousData, discreteData);
        }
        return null;
    }

    @Override
    public void setHasHeader(boolean hasHeader) {
        this.hasHeader = hasHeader;
    }

    @Override
    public void setQuoteCharacter(char quoteCharacter) {
        this.quoteChar = quoteCharacter;
    }
}

