/*
 * Decompiled with CFR 0.152.
 */
package edu.pitt.isp.sverchkov.data;

import edu.pitt.isp.sverchkov.data.ADTreeHelper;
import edu.pitt.isp.sverchkov.data.DataTable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ADTree<A, V>
extends ADTreeHelper {
    private final Map<A, Integer> attributeLookup;
    private final List<A> attributes;
    private final List<VHelper> values;
    private final ADTreeHelper.CountNode root;

    public ADTree(DataTable<A, V> data) {
        super(data.columnCount());
        HashMap attrLookup = new HashMap();
        ArrayList<A> attrs = new ArrayList<A>(data.variables());
        int i = 0;
        for (Object e : attrs) {
            attrLookup.put(e, i++);
        }
        this.attributeLookup = Collections.unmodifiableMap(attrLookup);
        this.attributes = Collections.unmodifiableList(attrs);
        int[][] array = new int[data.rowCount()][this.m];
        ArrayList<VHelper> v = new ArrayList<VHelper>(this.m);
        for (i = 0; i < this.m; ++i) {
            v.add(new VHelper());
        }
        int r = 0;
        for (List list : data) {
            for (int i2 = 0; i2 < this.m; ++i2) {
                Object value = list.get(i2);
                List vlist = ((VHelper)v.get(i2)).list;
                Map vmap = ((VHelper)v.get(i2)).map;
                if (!vlist.contains(value)) {
                    vmap.put(value, vlist.size());
                    vlist.add(value);
                    int n = i2;
                    this.airities[n] = this.airities[n] + 1;
                }
                array[r][i2] = (Integer)vmap.get(value);
            }
            ++r;
        }
        ListIterator<VHelper> iter = v.listIterator();
        while (iter.hasNext()) {
            VHelper vHelper = (VHelper)iter.next();
            iter.set(new VHelper(Collections.unmodifiableList(vHelper.list), Collections.unmodifiableMap(vHelper.map)));
        }
        this.values = Collections.unmodifiableList(v);
        this.root = new ADTreeHelper.CountNode(this.m, array);
    }

    public List<V> values(A attribute) {
        int index = Objects.requireNonNull(this.attributeLookup.get(attribute), "Attribute " + attribute.toString() + " not found.");
        return this.values.get(index).list;
    }

    public int count(Map<A, V> assignment) {
        int[] a = new int[this.m];
        for (int i = 0; i < this.m; ++i) {
            V value = assignment.get(this.attributes.get(i));
            a[i] = null != value ? (Integer)this.values.get(i).map.get(value) : -1;
        }
        return this.count(a, this.root);
    }

    public Map<V, Integer> counts(A attribute, Map<A, V> assignment) {
        List vlist = this.values.get(this.attributeLookup.get(attribute)).list;
        HashMap result = new HashMap(vlist.size());
        for (Object value : vlist) {
            HashMap a = new HashMap(assignment);
            a.put(attribute, value);
            result.put(value, this.count(a));
        }
        return result;
    }

    public Document toXML() throws ParserConfigurationException {
        return this.toXML(DocumentBuilderFactory.newInstance().newDocumentBuilder());
    }

    public Document toXML(DocumentBuilder builder) {
        Document doc = builder.newDocument();
        Element docRoot = doc.createElement("adtree");
        doc.appendChild(docRoot);
        if (null != this.root) {
            Element cNode = doc.createElement("count");
            this.recursiveXML(doc, cNode, this.root);
            docRoot.appendChild(cNode);
        }
        return doc;
    }

    private void recursiveXML(Document doc, Element cNode, ADTreeHelper.CountNode node) {
        cNode.setAttribute("count", Integer.toString(node.count));
        for (int i = 0; i < node.vary.length; ++i) {
            Element vNode = doc.createElement("vary");
            vNode.setAttribute("attribute", this.attributes.get(i).toString());
            cNode.appendChild(vNode);
            for (int j = 0; j < node.vary[i].values.length; ++j) {
                Element e;
                if (j == node.vary[i].mcv) {
                    e = doc.createElement("mcv");
                } else if (null == node.vary[i].values[j]) {
                    e = doc.createElement("null");
                } else {
                    e = doc.createElement("count");
                    this.recursiveXML(doc, e, node.vary[i].values[j]);
                }
                e.setAttribute("value", this.values.get(i).list.get(j).toString());
                vNode.appendChild(e);
            }
        }
    }

    private class VHelper
    implements Serializable {
        private final List<V> list;
        private final Map<V, Integer> map;

        private VHelper() {
            this.list = new ArrayList();
            this.map = new HashMap();
        }

        private VHelper(List<V> list, Map<V, Integer> map) {
            this.list = list;
            this.map = map;
        }
    }
}

