/*
 * Decompiled with CFR 0.152.
 */
package edu.pitt.isp.sverchkov.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class ADTreeHelper
implements Serializable {
    protected final int m;
    protected final int[] airities;

    protected ADTreeHelper(int m) {
        this.m = m;
        this.airities = new int[m];
    }

    protected int count(int[] assignment, CountNode ptr) {
        if (null == ptr) {
            return 0;
        }
        for (int i = ptr.attr - 1; i >= 0 && ptr != null; --i) {
            VaryNode vary = ptr.vary[i];
            if (assignment[i] < 0) continue;
            if (assignment[i] == vary.mcv) {
                int[] a = new int[this.m];
                System.arraycopy(assignment, 0, a, 0, this.m);
                a[i] = -1;
                int count = this.count(a, ptr);
                for (int v = 0; v < vary.values.length; ++v) {
                    if (v == vary.mcv) continue;
                    a[i] = v;
                    count -= this.count(a, ptr);
                }
                return count;
            }
            ptr = vary.values[assignment[i]];
        }
        return null == ptr ? 0 : ptr.count;
    }

    protected class CountNode
    implements Serializable {
        private final int attr;
        protected final int count;
        protected final VaryNode[] vary;

        protected CountNode(int attribute, int[][] array) {
            this.attr = attribute;
            this.count = array.length;
            this.vary = new VaryNode[this.attr];
            for (int i = 0; i < this.attr; ++i) {
                this.vary[i] = new VaryNode(i, array);
            }
        }
    }

    protected class VaryNode
    implements Serializable {
        protected final CountNode[] values;
        protected int mcv = -1;

        private VaryNode(int attr, int[][] array) {
            int i;
            System.out.println(attr);
            int airity = ADTreeHelper.this.airities[attr];
            this.values = new CountNode[airity];
            ArrayList childArrayIndexes = new ArrayList(airity);
            for (int i2 = 0; i2 < airity; ++i2) {
                childArrayIndexes.add(new ArrayList());
            }
            for (int r = 0; r < array.length; ++r) {
                ((List)childArrayIndexes.get(array[r][attr])).add(r);
            }
            int maxCount = 0;
            for (i = 0; i < airity; ++i) {
                int count = ((List)childArrayIndexes.get(i)).size();
                if (count <= maxCount) continue;
                maxCount = count;
                this.mcv = i;
            }
            for (i = 0; i < airity; ++i) {
                List indexes;
                if (i == this.mcv || (indexes = (List)childArrayIndexes.get(i)).size() <= 0) continue;
                int[][] childArray = new int[indexes.size()][];
                int j = 0;
                Iterator iterator = indexes.iterator();
                while (iterator.hasNext()) {
                    int index = (Integer)iterator.next();
                    childArray[j++] = array[index];
                }
                this.values[i] = new CountNode(attr, childArray);
            }
        }
    }
}

