/*
 * Decompiled with CFR 0.152.
 */
package edu.pitt.isp.sverchkov.data;

import edu.cmu.tetrad.bayes.BayesPm;
import edu.cmu.tetrad.bayes.MlBayesIm;
import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.RandomGraph;
import edu.cmu.tetrad.util.MillisecondTimes;
import edu.pitt.isp.sverchkov.data.ADTree;
import edu.pitt.isp.sverchkov.data.DataTableImpl;
import java.util.ArrayList;
import java.util.TreeMap;

public class ADTreeTest {
    public static void main(String[] args) throws Exception {
        int columns = 40;
        int numEdges = 40;
        int rows = 500;
        ArrayList<Node> variables = new ArrayList<Node>();
        ArrayList<String> varNames = new ArrayList<String>();
        for (int i = 0; i < 40; ++i) {
            String name = "X" + (i + 1);
            varNames.add(name);
            variables.add(new ContinuousVariable(name));
        }
        Graph graph = RandomGraph.randomGraphRandomForwardEdges(variables, 0, 40, 30, 15, 15, false, true);
        BayesPm pm = new BayesPm(graph);
        MlBayesIm im = new MlBayesIm(pm, 1);
        DataSet data = im.simulateData(500, false);
        DataTableImpl dataTable = new DataTableImpl(variables);
        for (int i = 0; i < 500; ++i) {
            ArrayList<Short> intArray = new ArrayList<Short>();
            for (int j = 0; j < 40; ++j) {
                intArray.add((short)data.getInt(i, j));
            }
            dataTable.addRow(intArray);
        }
        long start = MillisecondTimes.timeMillis();
        ADTree adTree = new ADTree(dataTable);
        System.out.printf("Generated tree in %s millis%n", MillisecondTimes.timeMillis() - start);
        TreeMap<Node, Short> query = new TreeMap<Node, Short>();
        query.put(ADTreeTest.node(pm, "X1"), (short)1);
        query.put(ADTreeTest.node(pm, "X5"), (short)0);
        start = MillisecondTimes.timeMillis();
        System.out.printf("Count is %d%n", adTree.count(query));
        System.out.printf("Query in %s ms%n", MillisecondTimes.timeMillis() - start);
        query.clear();
        query.put(ADTreeTest.node(pm, "X1"), (short)1);
        query.put(ADTreeTest.node(pm, "X2"), (short)1);
        query.put(ADTreeTest.node(pm, "X5"), (short)0);
        query.put(ADTreeTest.node(pm, "X10"), (short)1);
        start = MillisecondTimes.timeMillis();
        System.out.printf("Count is %d%n", adTree.count(query));
        System.out.printf("Query in %s ms%n", MillisecondTimes.timeMillis() - start);
    }

    private static Node node(BayesPm pm, String x1) {
        return pm.getNode(x1);
    }
}

