/*
 * Decompiled with CFR 0.152.
 */
package edu.pitt.isp.sverchkov.data;

import edu.pitt.isp.sverchkov.data.DataTable;
import edu.pitt.isp.sverchkov.data.DataTableImpl;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Scanner;

public class DataTools {
    public static final String NEWLINE = System.getProperty("line.separator");
    public static final String DELIMITER_REGEX = " *, *";
    public static final String DELIMITER = ", ";

    public static DataTable<String, String> dataTableFromFile(File file) throws FileNotFoundException {
        DataTableImpl<String, String> data = null;
        try (Scanner in = new Scanner(file);){
            data = new DataTableImpl<String, String>(Arrays.asList(in.nextLine().trim().split(DELIMITER_REGEX)));
            while (in.hasNextLine()) {
                data.addRow(Arrays.asList(in.nextLine().trim().split(DELIMITER_REGEX)));
            }
        }
        return data;
    }

    public static <Attribute, Value> void saveCSV(DataTable<Attribute, Value> data, File dest, boolean headers) throws IOException {
        try (BufferedWriter out = new BufferedWriter(new FileWriter(dest));){
            if (headers) {
                String delim = "";
                for (Attribute a : data.variables()) {
                    out.append(delim).append(a.toString());
                    delim = DELIMITER;
                }
                out.append(NEWLINE);
            }
            for (List list : data) {
                String delim = "";
                for (Object v : list) {
                    out.append(delim).append(v.toString());
                    delim = DELIMITER;
                }
                out.append(NEWLINE);
            }
        }
    }
}

