/*
 * Decompiled with CFR 0.152.
 */
package jgpml.covariancefunctions;

import Jama.Matrix;
import jgpml.covariancefunctions.CovarianceFunction;
import jgpml.covariancefunctions.MatrixOperations;
import org.apache.commons.math3.util.FastMath;

public class CovLINone
implements CovarianceFunction {
    @Override
    public int numParameters() {
        return 1;
    }

    @Override
    public Matrix compute(Matrix loghyper, Matrix X) {
        if (loghyper.getColumnDimension() != 1 || loghyper.getRowDimension() != this.numParameters()) {
            throw new IllegalArgumentException("Wrong number of hyperparameters, " + loghyper.getRowDimension() + " instead of " + this.numParameters());
        }
        double it2 = FastMath.exp(-2.0 * loghyper.get(0, 0));
        Matrix A = X.times(X.transpose());
        return MatrixOperations.addValue(A, 1.0).times(it2);
    }

    @Override
    public Matrix[] compute(Matrix loghyper, Matrix X, Matrix Xstar) {
        if (loghyper.getColumnDimension() != 1 || loghyper.getRowDimension() != this.numParameters()) {
            throw new IllegalArgumentException("Wrong number of hyperparameters, " + loghyper.getRowDimension() + " instead of " + this.numParameters());
        }
        double it2 = FastMath.exp(-2.0 * loghyper.get(0, 0));
        Matrix A = MatrixOperations.sumRows(Xstar.arrayTimes(Xstar));
        A = MatrixOperations.addValue(A, 1.0).times(it2);
        Matrix B = X.times(Xstar.transpose());
        B = MatrixOperations.addValue(B, 1.0).times(it2);
        return new Matrix[]{A, B};
    }

    @Override
    public Matrix computeDerivatives(Matrix loghyper, Matrix X, int index) {
        if (loghyper.getColumnDimension() != 1 || loghyper.getRowDimension() != this.numParameters()) {
            throw new IllegalArgumentException("Wrong number of hyperparameters, " + loghyper.getRowDimension() + " instead of " + this.numParameters());
        }
        if (index > this.numParameters() - 1) {
            throw new IllegalArgumentException("Wrong hyperparameters index " + index + " it should be smaller or equal to " + (this.numParameters() - 1));
        }
        double it2 = FastMath.exp(-2.0 * loghyper.get(0, 0));
        Matrix A = X.times(X.transpose());
        return MatrixOperations.addValue(A, 1.0).times(-2.0 * it2);
    }

    public static void main(String[] args) {
        CovLINone cf = new CovLINone();
        Matrix X = Matrix.identity(6, 6);
        Matrix logtheta = new Matrix(new double[][]{{0.1}});
        Matrix z = new Matrix(new double[][]{{1.0, 2.0, 3.0, 4.0, 5.0, 6.0}, {1.0, 2.0, 3.0, 4.0, 5.0, 6.0}});
        System.out.println();
        Matrix K = cf.compute(logtheta, X);
        K.print(K.getColumnDimension(), 8);
        Matrix[] res = cf.compute(logtheta, X, z);
        res[0].print(res[0].getColumnDimension(), 8);
        res[1].print(res[1].getColumnDimension(), 8);
        Matrix d = cf.computeDerivatives(logtheta, X, 0);
        d.print(d.getColumnDimension(), 8);
    }
}

