/*
 * Decompiled with CFR 0.152.
 */
package jgpml.covariancefunctions;

import Jama.Matrix;
import jgpml.covariancefunctions.CovarianceFunction;
import org.apache.commons.math3.util.FastMath;

public class CovNNone
implements CovarianceFunction {
    double[][] k;
    double[][] q;

    @Override
    public int numParameters() {
        return 2;
    }

    @Override
    public Matrix compute(Matrix loghyper, Matrix X) {
        if (loghyper.getColumnDimension() != 1 || loghyper.getRowDimension() != this.numParameters()) {
            throw new IllegalArgumentException("Wrong number of hyperparameters, " + loghyper.getRowDimension() + " instead of " + this.numParameters());
        }
        double ell = FastMath.exp(loghyper.get(0, 0));
        double em2 = 1.0 / (ell * ell);
        double oneplusem2 = 1.0 + em2;
        double sf2 = FastMath.exp(2.0 * loghyper.get(1, 0));
        int m = X.getRowDimension();
        int n = X.getColumnDimension();
        double[][] x = X.getArray();
        this.q = new double[m][m];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < m; ++j) {
                double t = 0.0;
                for (int k = 0; k < n; ++k) {
                    t += x[i][k] * x[j][k] * em2;
                }
                this.q[i][j] = t;
            }
        }
        double[] dq = new double[m];
        for (int i = 0; i < m; ++i) {
            dq[i] = FastMath.sqrt(oneplusem2 + this.q[i][i]);
        }
        Matrix A = new Matrix(m, m);
        double[][] k = new double[m][m];
        double[][] a = A.getArray();
        for (int i = 0; i < m; ++i) {
            double dqi = dq[i];
            for (int j = 0; j < m; ++j) {
                double t;
                k[i][j] = t = (em2 + this.q[i][j]) / (dqi * dq[j]);
                a[i][j] = sf2 * FastMath.asin(t);
            }
        }
        return A;
    }

    @Override
    public Matrix[] compute(Matrix loghyper, Matrix X, Matrix Xstar) {
        int i;
        if (loghyper.getColumnDimension() != 1 || loghyper.getRowDimension() != this.numParameters()) {
            throw new IllegalArgumentException("Wrong number of hyperparameters, " + loghyper.getRowDimension() + " instead of " + this.numParameters());
        }
        double ell = FastMath.exp(loghyper.get(0, 0));
        double em2 = 1.0 / (ell * ell);
        double oneplusem2 = 1.0 + em2;
        double sf2 = FastMath.exp(2.0 * loghyper.get(1, 0));
        int m = X.getRowDimension();
        int n = X.getColumnDimension();
        double[][] x = X.getArray();
        int mstar = Xstar.getRowDimension();
        int nstar = Xstar.getColumnDimension();
        double[][] xstar = Xstar.getArray();
        double[] sumxstardotTimesxstar = new double[mstar];
        for (int i2 = 0; i2 < mstar; ++i2) {
            double t = 0.0;
            for (int j = 0; j < nstar; ++j) {
                double tt = xstar[i2][j];
                t += tt * tt * em2;
            }
            sumxstardotTimesxstar[i2] = t;
        }
        Matrix A = new Matrix(mstar, 1);
        double[][] a = A.getArray();
        for (int i3 = 0; i3 < mstar; ++i3) {
            a[i3][0] = sf2 * FastMath.asin((em2 + sumxstardotTimesxstar[i3]) / (oneplusem2 + sumxstardotTimesxstar[i3]));
        }
        double[] sumxdotTimesx = new double[m];
        for (int i4 = 0; i4 < m; ++i4) {
            double t = 0.0;
            for (int j = 0; j < n; ++j) {
                double tt = x[i4][j];
                t += tt * tt * em2;
            }
            sumxdotTimesx[i4] = t + oneplusem2;
        }
        Matrix B = new Matrix(m, mstar);
        double[][] b = B.getArray();
        for (i = 0; i < m; ++i) {
            double[] xi = x[i];
            for (int j = 0; j < mstar; ++j) {
                double t = 0.0;
                double[] xstarj = xstar[j];
                for (int k = 0; k < n; ++k) {
                    t += xi[k] * xstarj[k] * em2;
                }
                b[i][j] = t + em2;
            }
        }
        for (i = 0; i < m; ++i) {
            for (int j = 0; j < mstar; ++j) {
                b[i][j] = sf2 * FastMath.asin(b[i][j] / FastMath.sqrt((sumxstardotTimesxstar[j] + oneplusem2) * sumxdotTimesx[i]));
            }
        }
        return new Matrix[]{A, B};
    }

    @Override
    public Matrix computeDerivatives(Matrix loghyper, Matrix X, int index) {
        Matrix A;
        int i;
        if (loghyper.getColumnDimension() != 1 || loghyper.getRowDimension() != this.numParameters()) {
            throw new IllegalArgumentException("Wrong number of hyperparameters, " + loghyper.getRowDimension() + " instead of " + this.numParameters());
        }
        if (index > this.numParameters() - 1) {
            throw new IllegalArgumentException("Wrong hyperparameters index " + index + " it should be smaller or equal to " + (this.numParameters() - 1));
        }
        double ell = FastMath.exp(loghyper.get(0, 0));
        double em2 = 1.0 / (ell * ell);
        double oneplusem2 = 1.0 + em2;
        double twosf2 = 2.0 * FastMath.exp(2.0 * loghyper.get(1, 0));
        int m = X.getRowDimension();
        int n = X.getColumnDimension();
        double[][] x = X.getArray();
        if (this.q == null || this.q.length != m || this.q[0].length != m) {
            this.q = new double[m][m];
            for (int i2 = 0; i2 < m; ++i2) {
                for (int j = 0; j < m; ++j) {
                    double t = 0.0;
                    for (int k = 0; k < n; ++k) {
                        t += x[i2][k] * x[j][k] * em2;
                    }
                    this.q[i2][j] = t;
                }
            }
        }
        double[] dq = new double[m];
        for (i = 0; i < m; ++i) {
            dq[i] = FastMath.sqrt(oneplusem2 + this.q[i][i]);
        }
        if (this.k == null || this.k.length != m || this.k[0].length != m) {
            this.k = new double[m][m];
            for (i = 0; i < m; ++i) {
                double dqi = dq[i];
                for (int j = 0; j < m; ++j) {
                    double t;
                    this.k[i][j] = t = (em2 + this.q[i][j]) / (dqi * dq[j]);
                }
            }
        }
        if (index == 0) {
            int j;
            int i3;
            for (int i4 = 0; i4 < m; ++i4) {
                dq[i4] = oneplusem2 + this.q[i4][i4];
            }
            double[] v = new double[m];
            for (i3 = 0; i3 < m; ++i3) {
                double t = 0.0;
                for (j = 0; j < n; ++j) {
                    double xij = x[i3][j];
                    t += xij * xij * em2;
                }
                v[i3] = (t + em2) / dq[i3];
            }
            for (i3 = 0; i3 < m; ++i3) {
                double vi = v[i3];
                for (j = 0; j < m; ++j) {
                    double t = (this.q[i3][j] + em2) / (FastMath.sqrt(dq[i3]) * FastMath.sqrt(dq[j]));
                    double kij = this.k[i3][j];
                    this.q[i3][j] = -twosf2 * ((t - 0.5 * kij * (vi + v[j])) / FastMath.sqrt(1.0 - kij * kij));
                }
            }
            A = new Matrix(this.q);
            this.q = null;
        } else {
            for (int i5 = 0; i5 < m; ++i5) {
                for (int j = 0; j < m; ++j) {
                    this.k[i5][j] = FastMath.asin(this.k[i5][j]) * twosf2;
                }
            }
            A = new Matrix(this.k);
            this.k = null;
        }
        return A;
    }

    public static void main(String[] args) {
        CovNNone cf = new CovNNone();
        Matrix X = Matrix.identity(6, 6);
        Matrix logtheta = new Matrix(new double[][]{{0.1}, {0.2}});
        Matrix z = new Matrix(new double[][]{{1.0, 2.0, 3.0, 4.0, 5.0, 6.0}, {1.0, 2.0, 3.0, 4.0, 5.0, 6.0}});
        Matrix d = cf.computeDerivatives(logtheta, X, 1);
        d.print(d.getColumnDimension(), 8);
    }
}

