/*
 * Decompiled with CFR 0.152.
 */
package jgpml.covariancefunctions;

import Jama.Matrix;
import java.util.Arrays;
import jgpml.covariancefunctions.CovarianceFunction;
import org.apache.commons.math3.util.FastMath;

public class CovNoise
implements CovarianceFunction {
    @Override
    public int numParameters() {
        return 1;
    }

    @Override
    public Matrix compute(Matrix loghyper, Matrix X) {
        if (loghyper.getColumnDimension() != 1 || loghyper.getRowDimension() != this.numParameters()) {
            throw new IllegalArgumentException("Wrong number of hyperparameters, " + loghyper.getRowDimension() + " instead of " + this.numParameters());
        }
        double s2 = FastMath.exp(2.0 * loghyper.get(0, 0));
        return Matrix.identity(X.getRowDimension(), X.getRowDimension()).times(s2);
    }

    @Override
    public Matrix[] compute(Matrix loghyper, Matrix X, Matrix Xstar) {
        if (loghyper.getColumnDimension() != 1 || loghyper.getRowDimension() != this.numParameters()) {
            throw new IllegalArgumentException("Wrong number of hyperparameters, " + loghyper.getRowDimension() + " instead of " + this.numParameters());
        }
        double s2 = FastMath.exp(2.0 * loghyper.get(0, 0));
        double[] a = new double[Xstar.getRowDimension()];
        Arrays.fill(a, s2);
        Matrix A = new Matrix(a, Xstar.getRowDimension());
        Matrix B = new Matrix(X.getRowDimension(), Xstar.getRowDimension());
        return new Matrix[]{A, B};
    }

    @Override
    public Matrix computeDerivatives(Matrix loghyper, Matrix X, int index) {
        if (loghyper.getColumnDimension() != 1 || loghyper.getRowDimension() != this.numParameters()) {
            throw new IllegalArgumentException("Wrong number of hyperparameters, " + loghyper.getRowDimension() + " instead of " + this.numParameters());
        }
        if (index > this.numParameters() - 1) {
            throw new IllegalArgumentException("Wrong hyperparameters index " + index + " it should be smaller or equal to " + (this.numParameters() - 1));
        }
        double s2 = FastMath.exp(2.0 * loghyper.get(0, 0));
        return Matrix.identity(X.getRowDimension(), X.getRowDimension()).times(2.0 * s2);
    }
}

