/*
 * Decompiled with CFR 0.152.
 */
package jgpml.covariancefunctions;

import Jama.Matrix;
import java.util.Arrays;
import jgpml.covariancefunctions.CovarianceFunction;
import jgpml.covariancefunctions.MatrixOperations;
import org.apache.commons.math3.util.FastMath;

public class CovSEiso
implements CovarianceFunction {
    @Override
    public int numParameters() {
        return 2;
    }

    @Override
    public Matrix compute(Matrix loghyper, Matrix X) {
        if (loghyper.getColumnDimension() != 1 || loghyper.getRowDimension() != this.numParameters()) {
            throw new IllegalArgumentException("Wrong number of hyperparameters, " + loghyper.getRowDimension() + " instead of " + this.numParameters());
        }
        double ell = FastMath.exp(loghyper.get(0, 0));
        double sf2 = FastMath.exp(2.0 * loghyper.get(1, 0));
        return MatrixOperations.exp(CovSEiso.squareDist(X.transpose().times(1.0 / ell)).times(-0.5)).times(sf2);
    }

    @Override
    public Matrix[] compute(Matrix loghyper, Matrix X, Matrix Xstar) {
        if (loghyper.getColumnDimension() != 1 || loghyper.getRowDimension() != this.numParameters()) {
            throw new IllegalArgumentException("Wrong number of hyperparameters, " + loghyper.getRowDimension() + " instead of " + this.numParameters());
        }
        double ell = FastMath.exp(loghyper.get(0, 0));
        double sf2 = FastMath.exp(2.0 * loghyper.get(1, 0));
        double[] a = new double[Xstar.getRowDimension()];
        Arrays.fill(a, sf2);
        Matrix A = new Matrix(a, a.length);
        Matrix B = MatrixOperations.exp(CovSEiso.squareDist(X.transpose().times(1.0 / ell), Xstar.transpose().times(1.0 / ell)).times(-0.5)).times(sf2);
        return new Matrix[]{A, B};
    }

    @Override
    public Matrix computeDerivatives(Matrix loghyper, Matrix X, int index) {
        if (loghyper.getColumnDimension() != 1 || loghyper.getRowDimension() != this.numParameters()) {
            throw new IllegalArgumentException("Wrong number of hyperparameters, " + loghyper.getRowDimension() + " instead of " + this.numParameters());
        }
        if (index > this.numParameters() - 1) {
            throw new IllegalArgumentException("Wrong hyperparameters index " + index + " it should be smaller or equal to " + (this.numParameters() - 1));
        }
        double ell = FastMath.exp(loghyper.get(0, 0));
        double sf2 = FastMath.exp(2.0 * loghyper.get(1, 0));
        Matrix tmp = CovSEiso.squareDist(X.transpose().times(1.0 / ell));
        Matrix A = null;
        A = index == 0 ? MatrixOperations.exp(tmp.times(-0.5)).arrayTimes(tmp).times(sf2) : MatrixOperations.exp(tmp.times(-0.5)).times(2.0 * sf2);
        return A;
    }

    private static Matrix squareDist(Matrix a) {
        return CovSEiso.squareDist(a, a);
    }

    private static Matrix squareDist(Matrix a, Matrix b) {
        Matrix C = new Matrix(a.getColumnDimension(), b.getColumnDimension());
        int m = a.getColumnDimension();
        int n = b.getColumnDimension();
        int d = a.getRowDimension();
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                double z = 0.0;
                for (int k = 0; k < d; ++k) {
                    double t = a.get(k, i) - b.get(k, j);
                    z += t * t;
                }
                C.set(i, j, z);
            }
        }
        return C;
    }

    public static void main(String[] args) {
        CovSEiso cf = new CovSEiso();
        Matrix X = Matrix.identity(6, 6);
        Matrix logtheta = new Matrix(new double[][]{{0.1}, {0.2}});
        Matrix d = cf.computeDerivatives(logtheta, X, 1);
        d.print(d.getColumnDimension(), 8);
    }
}

