/*
 * Decompiled with CFR 0.152.
 */
package jgpml.covariancefunctions;

import Jama.Matrix;
import org.apache.commons.math3.util.FastMath;

public class MatrixOperations {
    public static Matrix exp(Matrix A) {
        Matrix out = new Matrix(A.getRowDimension(), A.getColumnDimension());
        for (int i = 0; i < A.getRowDimension(); ++i) {
            for (int j = 0; j < A.getColumnDimension(); ++j) {
                out.set(i, j, FastMath.exp(A.get(i, j)));
            }
        }
        return out;
    }

    public static Matrix sumRows(Matrix A) {
        Matrix sum = new Matrix(A.getRowDimension(), 1);
        for (int i = 0; i < A.getColumnDimension(); ++i) {
            sum.plusEquals(A.getMatrix(0, A.getRowDimension() - 1, i, i));
        }
        return sum;
    }

    public static Matrix addValue(Matrix A, double val) {
        for (int i = 0; i < A.getRowDimension(); ++i) {
            for (int j = 0; j < A.getColumnDimension(); ++j) {
                A.set(i, j, A.get(i, j) + val);
            }
        }
        return A;
    }

    public static Matrix asin(Matrix A) {
        Matrix out = new Matrix(A.getRowDimension(), A.getColumnDimension());
        for (int i = 0; i < A.getRowDimension(); ++i) {
            for (int j = 0; j < A.getColumnDimension(); ++j) {
                out.set(i, j, FastMath.asin(A.get(i, j)));
            }
        }
        return out;
    }

    public static Matrix sqrt(Matrix A) {
        Matrix out = new Matrix(A.getRowDimension(), A.getColumnDimension());
        for (int i = 0; i < A.getRowDimension(); ++i) {
            for (int j = 0; j < A.getColumnDimension(); ++j) {
                out.set(i, j, FastMath.sqrt(A.get(i, j)));
            }
        }
        return out;
    }

    public static Matrix diag(Matrix A) {
        Matrix diag = null;
        if (A.getColumnDimension() == 1 || A.getRowDimension() == 1) {
            if (A.getColumnDimension() == 1) {
                diag = new Matrix(A.getRowDimension(), A.getRowDimension());
                for (int i = 0; i < diag.getColumnDimension(); ++i) {
                    diag.set(i, i, A.get(i, 0));
                }
            } else {
                diag = new Matrix(A.getColumnDimension(), A.getColumnDimension());
                for (int i = 0; i < diag.getRowDimension(); ++i) {
                    diag.set(i, i, A.get(0, i));
                }
            }
        } else {
            diag = new Matrix(A.getRowDimension(), 1);
            for (int i = 0; i < diag.getRowDimension(); ++i) {
                diag.set(i, 0, A.get(i, i));
            }
        }
        return diag;
    }

    public static Matrix mean(Matrix A) {
        if (A.getRowDimension() == 1) {
            double m = 0.0;
            for (int i = 0; i < A.getColumnDimension(); ++i) {
                m += A.get(0, i);
            }
            Matrix M = new Matrix(1, 1);
            M.set(0, 0, m / (double)A.getColumnDimension());
            return M;
        }
        Matrix M = new Matrix(1, A.getColumnDimension());
        for (int i = 0; i < A.getColumnDimension(); ++i) {
            double m = 0.0;
            for (int j = 0; j < A.getRowDimension(); ++j) {
                m += A.get(j, i);
            }
            M.set(0, i, m / (double)A.getRowDimension());
        }
        return M;
    }

    public static Matrix std(Matrix A) {
        if (A.getRowDimension() == 1) {
            double m = 0.0;
            double var = 0.0;
            for (int i = 0; i < A.getColumnDimension(); ++i) {
                m = (m * (double)(i - 1) + A.get(0, i)) / (double)i;
                var = var * (double)(i - 1) / (double)i + (A.get(0, i) - m) * (A.get(0, i) - m) / (double)(i - 1);
            }
            Matrix M = new Matrix(1, 1);
            M.set(0, 0, FastMath.sqrt(var));
            return M;
        }
        Matrix M = new Matrix(1, A.getColumnDimension());
        for (int i = 0; i < A.getColumnDimension(); ++i) {
            double m = 0.0;
            double var = 0.0;
            for (int j = 0; j < A.getRowDimension(); ++j) {
                m = (m * (double)(j - 1) + A.get(j, i)) / (double)j;
                var = var * (double)(j - 1) / (double)j + (A.get(j, i) - m) * (A.get(j, i) - m) / (double)(j - 1);
            }
            M.set(0, i, FastMath.sqrt(var));
        }
        return M;
    }
}

