import json
import random
import argparse

def str2bool(v):
    if v == 'True':
        return True
    elif v == 'False':
        return False
    else:
        argparse.ArgumentTypeError('Boolean value expected.')

parser = argparse.ArgumentParser(description='generate random config for AE')
parser.add_argument('--with_default', type=str2bool, default=False, help='add default config or not')
parser.add_argument('--seed', type=int, default=1024, help='random seed')
parser.add_argument('--n_algorithms', type=int, default=4, help='number of algorithm need to generate')
parser.add_argument('--output', type=str, default=None, help='config output file, in .json')
args = parser.parse_args()
print(args)

random.seed(1024)

PAP = {
    'configs': []
}
if args.with_default:
    print(args.with_default)
    PAP['configs'].append({
        'algorithm': 'fges',
        'penalty': 1.0,
        'faithful': False,
        'degree': 1000

    })
    PAP['configs'].append({
        'algorithm': 'pcstable',
        'alpha': 0.05,
        'depth': 1000 
    })

while len(PAP['configs']) < args.n_algorithms:
    if len(PAP['configs']) % 2 == 0:
        PAP['configs'].append({
            'algorithm': 'fges',
            'penalty': random.uniform(1.0, 1000.0),
            'faithful': random.choice([True, False]),
            'degree': random.randint(1, 1000)
        })
    else:
        PAP['configs'].append({
            'algorithm': 'pcstable',
            'alpha': random.uniform(0.01, 0.2),
            'depth': random.randint(1, 1000) 
        })

with open(args.output, 'w') as f:
    json.dump(PAP, f, indent='\t')
        


