import os
import time
import json
import random
import subprocess


OUTPUT_DIR = './training_set'
graph_features = {'asia': [8, 8], 'cancer': [5, 4], 'earthquake': [5, 4], 'sachs': [11, 17], 'survey': [6, 6], 'alarm': [37, 46], 'barley': [48, 84], 'child': [20, 25], 'insurance': [27, 52], 'mildew': [35, 46], 'water': [32, 66], 'hailfinder': [56, 66], 'hepar2': [70, 123], 'win95pts': [76, 112], 'andes': [223, 338], 'diabetes': [413, 602], 'link': [724, 1125], 'munin1': [186, 273], 'pathfinder': [109, 195], 'pigs': [441, 592], 'munin': [1041, 1397], 'munin2': [1003, 1244], 'munin3': [1041, 1306], 'munin4': [1038, 1388], 'ecoli70': [46, 70], 'magic-niab': [44, 66], 'magic-irri': [64, 102], 'arth150': [107, 150], 'healthcare': [7, 9], 'sangiovese': [15, 55], 'mehra-original': [24, 71], 'mehra-complete': [24, 71]}

if not os.path.exists(OUTPUT_DIR):
    os.makedirs(OUTPUT_DIR)

s_time = time.time()
json_temp = {}
for instance_i in range(1, 101):
    s_node = 1001
    while s_node > 1000:
        c_name = random.choice(list(graph_features))
        s_node = graph_features[c_name][0]
    k = random.randint(1, 1000 // graph_features[c_name][0])
    n_samples = random.choice([1000, 10000])
    seed = random.randint(1025, 2056)

    cmd = 'python json2dataset.py' + \
        ' --json ./original/{}.json'.format(c_name) + \
        ' --k {}'.format(k) + \
        ' --c {}'.format(0.1) + \
        ' --n_samples {}'.format(n_samples) + \
        ' --seed {}'.format(seed) + \
        ' --nx {}'.format(os.path.join(OUTPUT_DIR, f'instance_{instance_i}.json')) + \
        ' --npz {}'.format(os.path.join(OUTPUT_DIR, f'instance_{instance_i}.npz')) + \
        ' --npy {}'.format(os.path.join(OUTPUT_DIR, f'instance_{instance_i}.npy'))
    p = subprocess.Popen(cmd, shell=True)
    p.wait()

    print(f'instance {instance_i}: {c_name}, {k} - {k*s_node}, {n_samples}, {seed}, {time.time()-s_time} seconds')
    json_temp[f'instance_{instance_i}'] = [c_name, k, n_samples, seed]

    with open(os.path.join(OUTPUT_DIR, 'meta_data.json'), 'w') as f:
        json.dump(json_temp, f)


