library(rjson)
library(bnlearn)
library(argparse)

parser <- ArgumentParser(description="transfer .rds file to .json file")
parser$add_argument("-r", "--rds", type="character", help=".rds format file path")
parser$add_argument("-j", "--json", type="character", help=".json format file path")
args <- parser$parse_args()

bn_network <- readRDS(args$rds)
write(toJSON(bn_network, indent = 4), file = args$json)
