import json
import argparse
import numpy as np


parser = argparse.ArgumentParser(description='compare results')
parser.add_argument('--result', type=str, help='path of result')
args = parser.parse_args()


def load_result(path):
    with open(path) as f:
        result = json.load(f)

    subtype = 'alarm'
    temp_f1_adj = []
    temp_f1_arr = []
    temp_runtime = []
    for seed in range(1, 11):
        metrics = result['{}_{}'.format(subtype, seed)]
        if metrics['success'] == False or metrics['runtime'] > 86400:
            temp_f1_adj.append(0.0)
            temp_f1_arr.append(0.0)
            temp_runtime.append(86400)
            continue
        temp_f1_adj.append(metrics['f1_adj'])
        temp_f1_arr.append(metrics['f1_arrow'])
        temp_runtime.append(metrics['runtime'])

    return [temp_f1_adj, temp_f1_arr, temp_runtime]


r1 = load_result(args.result)

print('F1 Adjacent: {:.3f}±{:.3f}\nF1 Arrowhead: {:.3f}±{:.3f}\nRuntime: {:.1f}±{:.1f}'.format(np.mean(r1[0]), np.std(r1[0]), 
                                                                                              np.mean(r1[1]) ,np.std(r1[1]), 
                                                                                              np.mean(r1[2]), np.std(r1[2])))
