import os

import librosa
import mido

import lib.util as util


perf_dir = 'data/perf'
score_dir = 'data/score'
os.makedirs('data/score_rescaled', exist_ok=True)

for fname in os.listdir(perf_dir):
    if fname.endswith('.wav'):
        perf_fname = os.path.join(perf_dir, fname)
        midi_fname = os.path.join(score_dir, util.map_score(perf_fname) + '.midi')
        perf_dur = librosa.get_duration(filename=perf_fname)
        md = mido.MidiFile(midi_fname)
        rescale = md.length / perf_dur
        md.ticks_per_beat = int(md.ticks_per_beat * rescale)
        md.save(os.path.join('data/score_rescaled', fname[:-4] + '.midi'))

