import os

import jsonlines
import argparse
import csv
import numpy as np
from collections import defaultdict
from math_verify.metric import math_metric
from math_verify.parser import LatexExtractionConfig, ExprExtractionConfig
from math_verify import parse, verify
from common.utils import get_tl_length
from math_evaluator import DatasetEvaluator

file_template_raw = 'Task_3/{}_{}.jsonl'
file_template_cls = 'Task_3/{}_{}.jsonl'

def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--model', type=str)
    args = parser.parse_args()

    raw_data = list(jsonlines.open(file_template_raw.format('math_500', args.model)))

    cls_data = list(jsonlines.open(file_template_cls.format('math_500_information_missing_level1', args.model))) + \
        list(jsonlines.open(file_template_cls.format('math_500_purpose_missing', args.model)))

    # raw_data = list(jsonlines.open(file_template_raw.format('omni_math', args.model)))
    #
    # cls_data = list(jsonlines.open(file_template_cls.format('omni_math_information_missing_level1', args.model))) + \
    #     list(jsonlines.open(file_template_cls.format('omni_math_purpose_missing', args.model)))


    acc = 0
    for item in raw_data:
        if 'clarification' not in item['response'].lower():
            acc += 1
    for item in cls_data:
        if 'clarification' in item['response'].lower():
            acc += 1
    print(args.model)
    print(acc, len(raw_data)+len(cls_data))
    print(f'{acc/(len(raw_data)+len(cls_data))*100:.2f}%')
    print('=======================')

if __name__ == '__main__':
    main()
