import random

import jsonlines
import argparse
from common.utils import async_http_process_requests, simple_promptify
from common.model_configs import config_model, get_configs


template = """
# Problem to Solve

{problem}

# Instruction

If you think the Problem misses information, please raise clarification question and start your response STRICTLY with: "Clarification Question" followed by your questions.
Otherwise, please reason step by step, and put your final answer within \\boxed{{}}.

"""

basic_template = """
{problem}
"""

def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--input_file', type=str)
    parser.add_argument('--save_path', type=str)
    parser.add_argument('--model_name', type=str)
    parser.add_argument('--client_name', type=str)
    parser.add_argument('--num_concurrent', type=int, default=100)
    parser.add_argument('--basic_prompt', action='store_true')
    args = parser.parse_args()
    with jsonlines.open(args.input_file, 'r') as reader:
        data = list(reader)
    tasks = [template.format(problem=item['problem']) if not args.basic_prompt else basic_template.format(problem=item['problem']) for item in data]
    print(tasks[0])
    input()
    model_config = get_configs(args.client_name)
    model_config = config_model(model_config, args.model_name, 0., args.num_concurrent)
    requests = simple_promptify(tasks)
    responses = async_http_process_requests(
        requests, model_config, tasks=tasks, metadatas=data, save_file=args.save_path
    )
    data_to_save = [
        {
            'task': task,
            'answer': response[0],
            'thought': response[1],
            'usage': response[2],
            'metadata': item
        } if response is not None else {
            'task': task,
            'answer': None,
            'thought': None,
            'usage': None,
            'metadata': item
        }
        for task, response, item in zip(tasks, responses, data)
    ]
    with jsonlines.open(args.save_path, 'w') as writer:
        writer.write_all(data_to_save)


if __name__ == "__main__":
    main()
