import jsonlines
import argparse
from tqdm import tqdm
from evaluation import verify_math


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--input_file_raw', type=str)
    parser.add_argument('--input_file_raw_non_parsed', type=str)
    parser.add_argument('--input_file_im', type=str)
    parser.add_argument('--input_file_pm', type=str)
    parser.add_argument('--output_file', type=str)
    args = parser.parse_args()
    data_raw = list(jsonlines.open(args.input_file_raw))
    data_raw_non_parsed = list(jsonlines.open(args.input_file_raw_non_parsed))
    data_im = list(jsonlines.open(args.input_file_im))
    data_pm = list(jsonlines.open(args.input_file_pm))
    data = []
    for item in tqdm(data_raw+data_raw_non_parsed):
        gold = item['metadata']['answer']
        answer = item['answer']
        if verify_math(gold, answer):
            data.append({
                'p': item['metadata']['raw_task'],
                's': item['metadata']['solution'],
                'reason_of_incompleteness': None,
                'l_g': None
            })
    for item in tqdm(data_im+data_pm):
        answer = item['answer']
        if 'clarification' in answer.lower():
            thought = item['thought']
            data.append({
                'p': item['metadata']['unclear_task'],
                's': item['metadata']['solution'],
                'reason_of_incompleteness': item['metadata']['reason_of_unclearness'],
                'l_g': None
            })
    with jsonlines.open(args.output_file, 'w') as writer:
        writer.write_all(data)


if __name__ == '__main__':
    main()
