import argparse
import jsonlines
import numpy as np
from collections import defaultdict

parser = argparse.ArgumentParser()
parser.add_argument('--input_path', type=str)
args = parser.parse_args()

data = list(jsonlines.open(args.input_path))
info_len_level = defaultdict(list)
for item in data:
    info_list = item['metadata']['filtered_info_list']
    level = item['metadata']['level']
    info_len_level[level].append(len(info_list))

info_len_level = {k: np.mean(v) for k, v in info_len_level.items()}
print(info_len_level)
