import argparse
import jsonlines
import numpy as np


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--input_file', type=str, required=True)
    args = parser.parse_args()

    data = list(jsonlines.open(args.input_file))
    keywords = ['alternative', 'wait', 'but', 'check']
    filtered_thoughts_nums = []
    for item in data:
        thoughts = item['thought'].split('\n\n')
        filtered_thoughts_num = 0
        for thought in thoughts:
            flag = False
            for keyword in keywords:
                if keyword in thought.lower():
                    flag = True
                    break
            if flag:
                filtered_thoughts_num += 1
        filtered_thoughts_nums.append(filtered_thoughts_num)
    print(np.mean(filtered_thoughts_nums))


if __name__ == '__main__':
    main()
