import os
import argparse
import jsonlines
import numpy as np


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--input_file', type=str)
    args = parser.parse_args()

    data = list(jsonlines.open(args.input_file))
    thought_len_0, thought_len_1 = [], []
    for item in data:
        if item['judge_res']:
            thought_len_1.append(len(item['thought']))
        else:
            thought_len_0.append(len(item['thought']))
    print(np.mean(thought_len_0))
    print(np.mean(thought_len_1))


if __name__ == '__main__':
    main()
