import os
import jsonlines
import argparse

def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--input_file', type=str, default=None)
    args = parser.parse_args()

    data = list(jsonlines.open(args.input_file))
    non_cls_data, cls_data = [], []
    for item in data:
        answer, thought = item['answer'], item['thought']
        unclear_task = item['metadata']['unclear_task']
        raw_task = item['metadata']['raw_task']
        reason_of_unclearness = item['metadata']['reason_of_unclearness'] if 'reason_of_unclearness' in item['metadata'] else "The task is unclear because the goal is irrelevant to the information."
        if answer is None:
            continue
        data_to_save = {
            'unclear_task': unclear_task,
            'raw_task': raw_task,
            'answer': answer,
            'thought': thought,
            'reason_of_unclearness': reason_of_unclearness
        }
        if 'clarification' in item['answer'].lower():
            cls_data.append(data_to_save)
        else:
            non_cls_data.append(data_to_save)
    prefix = '.'.join(args.input_file.split('.')[:-1])
    cls_save_file = f'{prefix}_cls_data.jsonl'
    non_cls_save_file = f'{prefix}_non_cls_data.jsonl'
    with jsonlines.open(cls_save_file, 'w') as writer:
        writer.write_all(cls_data)
    with jsonlines.open(non_cls_save_file, 'w') as writer:
        writer.write_all(non_cls_data)


if __name__ == "__main__":
    main()
