import os
import argparse
import jsonlines
from evaluation import get_thought_answer

def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--input_file', type=str, required=True)
    args = parser.parse_args()

    data = list(jsonlines.open(args.input_file))
    for item in data:
        response = item['response']
        thought, answer = get_thought_answer(response)
        os.system('clear')
        print(thought)
        print('=============')
        print(answer)
        input()


if __name__ == "__main__":
    main()
