import os

import jsonlines
import argparse
from common.utils import get_tl_length
from evaluation import get_thought_answer

file_template_raw = 'Task_3/{}_{}.jsonl'
file_template_cls = 'Task_3/{}_{}.jsonl'

def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--model', type=str)
    parser.add_argument('--parse', action='store_true')
    args = parser.parse_args()

    raw_data = list(jsonlines.open(file_template_raw.format('math_500', args.model))) + \
        list(jsonlines.open(file_template_raw.format('omni_math', args.model)))

    cls_data = list(jsonlines.open(file_template_cls.format('math_500_information_missing_level1', args.model))) + \
        list(jsonlines.open(file_template_cls.format('math_500_purpose_missing', args.model))) + \
        list(jsonlines.open(file_template_cls.format('omni_math_information_missing_level1', args.model))) + \
        list(jsonlines.open(file_template_cls.format('omni_math_purpose_missing', args.model)))

    acc = 0
    for item in raw_data:
        if args.parse:
            answer = get_thought_answer(item['response'])[1]
        else:
            answer = item['response']
        if 'clarification' not in answer.lower():
            acc += 1
    for item in cls_data:
        if args.parse:
            answer = get_thought_answer(item['response'])[1]
        else:
            answer = item['response']
        if 'clarification' in answer.lower():
            acc += 1
    print(args.model)
    print(acc, len(raw_data)+len(cls_data))
    print(f'{acc/(len(raw_data)+len(cls_data))*100:.2f}%')
    print('=======================')

if __name__ == '__main__':
    main()
