
import jsonlines
import pandas as pd
from datasets import DatasetDict, Dataset


def level_map(level):
    if level in [1, 1.5]: return 1
    elif level in [2, 2.25]: return 2
    elif level in [2.5]: return 3
    elif level in [3, 3.5]: return 4
    elif level in [4]: return 5
    else: raise ValueError('Unknown level')


def load_data_incomplete(json_file, type, remap):
    data = list(jsonlines.open(json_file))
    res_data = []
    for item in data:
        res_data.append({
            'p': item['unclear_task'],
            's': item['solution'],
            'r': item['reason_of_unclearness'],
            'l_g': float(item['level']) if not remap else float(level_map(item['level'])),
            'type': type
        })
    return res_data

def load_data_raw(json_file, remap):
    data = list(jsonlines.open(json_file))
    res_data = []
    for item in data:
        res_data.append({
            'p': item['raw_task'],
            's': item['solution'],
            'r': 'None',
            'l_g': float(item['level']) if not remap else float(level_map(item['level'])),
            'type': 'well_defined'
        })
    return res_data


math_500_mp = load_data_incomplete('eval_data/math_500_information_missing_level1_verified_pp.jsonl', 'missing_premise', False)
math_500_mg = load_data_incomplete('eval_data/math_500_purpose_missing_verified_pp.jsonl', 'missing_goal', False)
math_500_wd = load_data_raw('eval_data/math_500_parsed_reassemble_verified_pp.jsonl', False)

math_500 = math_500_mp + math_500_mg + math_500_wd

omni_math_mp = load_data_incomplete('eval_data/omni_math_information_missing_level1_verified_pp.jsonl', 'missing_premise', True)
omni_math_mg = load_data_incomplete('eval_data/omni_math_purpose_missing_verified_pp.jsonl', 'missing_goal', True)
omni_math_wd = load_data_raw('eval_data/omni_math_parsed_reassemble_verified_pp.jsonl', True)

omni_math = omni_math_mp + omni_math_mg + omni_math_wd

check = 0
openr1 = list(jsonlines.open('Task_1/openr1_math_critic_bench.jsonl'))
for item in openr1:
    if not item['reason_of_incompleteness']:
        item['reason_of_incompleteness'] = 'None'
        item['type'] = 'well_defined'
    else:
        if item['reason_of_incompleteness'] == 'The problem lacks a specified goal to answer.':
            check += 1
            item['type'] = 'missing_goal'
        else:
            item['type'] = 'missing_premise'
    item['r'] = item['reason_of_incompleteness']
    item.pop('reason_of_incompleteness')
    item['l_g'] = -1.0

new_data = DatasetDict({
    'math_500': Dataset.from_pandas(pd.DataFrame(data=math_500)),
    'omni_math': Dataset.from_pandas(pd.DataFrame(data=omni_math)),
    'openr1_math': Dataset.from_pandas(pd.DataFrame(data=openr1))
})

new_data.push_to_hub("anonyneurips25/CRITIC-math")
