import jsonlines
import random
from datasets import load_dataset

ds = load_dataset('openai/gsm8k', 'main', split='test')
output_data = []
for item in ds:
    output_data.append({
        'problem': item['question'],
        'solution': item['answer'],
        'level': None,
    })
random.shuffle(output_data)
output_data = output_data[:500]
with jsonlines.open('critic_bench/gsm8k.jsonl', 'w') as writer:
    writer.write_all(output_data)
