import argparse
import jsonlines


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--input_file', type=str, required=True)
    parser.add_argument('--output_file', type=str, required=True)
    args = parser.parse_args()

    with jsonlines.open(args.input_file) as reader:
        data = list(reader)
    verification_output, decomposition_output = [], []
    for item in data:
        if item['verification_res']:
            continue
        verification_output.append({
            'r1_verification': item['verification'],
            'reassemble_task': item['metadata']['reassemble_task'],
            'raw_task': item['metadata']['raw_task'],
            'solution': item['metadata']['metadata']['solution'],
            'answer': item['metadata']['metadata']['answer'],
            'level': item['metadata']['metadata']['level'],
            'metadata': item['metadata']['metadata'],
        })
        decomposition_output.append(item['metadata']['metadata'])
    print(len(verification_output))
    file_name = '.'.join(args.input_file.split('.')[:-1])
    output_file = f'{file_name}_pp.jsonl'
    with jsonlines.open(output_file, 'w') as writer:
        writer.write_all(verification_output)
    with jsonlines.open(args.output_file, 'w') as writer:
        writer.write_all(decomposition_output)


if __name__ == '__main__':
    main()
