import json
import jsonlines
import argparse
import random


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--input_file', type=str)
    parser.add_argument('--output_file', type=str)
    args = parser.parse_args()

    data = list(jsonlines.open(args.input_file))
    random.shuffle(data)
    data = data[:len(data)//10]
    output_file = [
        {
            'incomplete_problem': item['unclear_task'],
            'raw_task': item['raw_task'],
            'reason_of_incompleteness': item['reason_of_unclearness'],
            'r1_judge': item['r1_verification']['verification']
        }
        for item in data
    ]

    with open(args.output_file, 'w') as writer:
        json.dump(output_file, writer)


if __name__ == '__main__':
    main()
