import argparse
import jsonlines


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--input_file', type=str, required=True)
    args = parser.parse_args()

    with jsonlines.open(args.input_file) as reader:
        data = list(reader)
    output_data = []
    for item in data:
        if not item['verification_res']:
            continue
        current_data = {
            'r1_verification': {
                'prompt': item['verification_prompt'],
                'verification_res': item['verification_res'],
                'verification': item['verification'],
            },
            'unclear_task': item['metadata']['unclear_task'],
            'raw_task': item['metadata']['raw_task'],
            'reason_of_unclearness': item['metadata']['reason_of_unclearness'],
            'solution': item['metadata']['solution'],
            'answer': item['metadata']['answer'],
            'level': item['metadata']['level'],
            'metadata': item['metadata']['metadata']
        }
        output_data.append(current_data)
    print(len(output_data))
    file_name = '.'.join(args.input_file.split('.')[:-1])
    output_file = f'{file_name}_pp.jsonl'
    with jsonlines.open(output_file, 'w') as writer:
        writer.write_all(output_data)


if __name__ == '__main__':
    main()
