#/bin/bash

prefix='openr1_math'
model_prefix='/data/model_path/models'
PYTHONPATH=$PYTHONPATH:$(pwd):$(pwd) python Task_3/data_organization_qwen25.py --input_file_non_cls Task_1/${prefix}_non_cls_training.jsonl --input_file_cls Task_1/${prefix}_cls_training.jsonl --output_file sft_data/${prefix}_qwen25_type1.jsonl
PYTHONPATH=$PYTHONPATH:$(pwd):$(pwd) python Task_3/data_organization_qwen25.py --input_file_non_cls Task_1/${prefix}_non_cls_training.jsonl --output_file sft_data/${prefix}_qwen25_type2.jsonl
PYTHONPATH=$PYTHONPATH:$(pwd):$(pwd) python Task_3/data_organization_qwen25.py --input_file_cls Task_1/${prefix}_cls_training.jsonl --output_file sft_data/${prefix}_qwen25_type3.jsonl

PYTHONPATH=$PYTHONPATH:$(pwd):$(pwd) python Task_3/data_organization_qwen25.py --input_file_non_cls Task_1/${prefix}_non_cls_training.jsonl --input_file_cls Task_1/${prefix}_cls_training.jsonl --output_file sft_data/${prefix}_qwen25_type4.jsonl --include_thought
PYTHONPATH=$PYTHONPATH:$(pwd):$(pwd) python Task_3/data_organization_qwen25.py --input_file_non_cls Task_1/${prefix}_non_cls_training.jsonl --output_file sft_data/${prefix}_qwen25_type5.jsonl --include_thought
PYTHONPATH=$PYTHONPATH:$(pwd):$(pwd) python Task_3/data_organization_qwen25.py --input_file_cls Task_1/${prefix}_cls_training.jsonl --output_file sft_data/${prefix}_qwen25_type6.jsonl --include_thought

deepspeed --module openrlhf.cli.train_sft \
   --max_len 10240 \
   --dataset sft_data/${prefix}_qwen_type1.jsonl \
   --input_key prompt \
   --output_key response \
   --train_batch_size 64 \
   --micro_train_batch_size 8 \
   --apply_chat_template \
   --max_samples 500000 \
   --pretrain ${model_prefix}/Qwen2.5-7B-Instruct \
   --save_path sft_ckpt/qwen257b_type1_sft \
   --save_steps -1 \
   --logging_steps 1 \
   --eval_steps -1 \
   --zero_stage 3 \
   --max_epochs 1 \
   --bf16 \
   --flash_attn \
   --learning_rate 1e-5 \
   --load_checkpoint \
   --packing_samples \
   --gradient_checkpointing

#deepspeed --module openrlhf.cli.train_sft \
#   --max_len 10240 \
#   --dataset sft_data/${prefix}_qwen_type2.jsonl \
#   --input_key prompt \
#   --output_key response \
#   --train_batch_size 64 \
#   --micro_train_batch_size 8 \
#   --apply_chat_template \
#   --max_samples 500000 \
#   --pretrain ${model_prefix}/Qwen2.5-7B-Instruct \
#   --save_path sft_ckpt/qwen257b_type2_sft \
#   --save_steps -1 \
#   --logging_steps 1 \
#   --eval_steps -1 \
#   --zero_stage 3 \
#   --max_epochs 1 \
#   --bf16 \
#   --flash_attn \
#   --learning_rate 1e-5 \
#   --load_checkpoint \
#   --packing_samples \
#   --gradient_checkpointing

deepspeed --module openrlhf.cli.train_sft \
   --max_len 10240 \
   --dataset sft_data/${prefix}_qwen_type3.jsonl \
   --input_key prompt \
   --output_key response \
   --train_batch_size 64 \
   --micro_train_batch_size 8 \
   --apply_chat_template \
   --max_samples 500000 \
   --pretrain ${model_prefix}/Qwen2.5-7B-Instruct \
   --save_path sft_ckpt/qwen257b_type3_sft \
   --save_steps -1 \
   --logging_steps 1 \
   --eval_steps -1 \
   --zero_stage 3 \
   --max_epochs 1 \
   --bf16 \
   --flash_attn \
   --learning_rate 1e-5 \
   --load_checkpoint \
   --packing_samples \
   --gradient_checkpointing

deepspeed --module openrlhf.cli.train_sft \
   --max_len 20480 \
   --dataset sft_data/${prefix}_qwen_type4.jsonl \
   --input_key prompt \
   --output_key response \
   --train_batch_size 64 \
   --micro_train_batch_size 1 \
   --apply_chat_template \
   --max_samples 500000 \
   --pretrain ${model_prefix}/Qwen2.5-7B-Instruct \
   --save_path sft_ckpt/qwen257b_type4_sft \
   --save_steps -1 \
   --logging_steps 1 \
   --eval_steps -1 \
   --zero_stage 3 \
   --max_epochs 1 \
   --bf16 \
   --flash_attn \
   --learning_rate 1e-5 \
   --load_checkpoint \
   --packing_samples \
   --gradient_checkpointing

#deepspeed --module openrlhf.cli.train_sft \
#   --max_len 20480 \
#   --dataset sft_data/${prefix}_qwen_type5.jsonl \
#   --input_key prompt \
#   --output_key response \
#   --train_batch_size 64 \
#   --micro_train_batch_size 1 \
#   --apply_chat_template \
#   --max_samples 500000 \
#   --pretrain ${model_prefix}/Qwen2.5-7B-Instruct \
#   --save_path sft_ckpt/qwen257b_type5_sft \
#   --save_steps -1 \
#   --logging_steps 1 \
#   --eval_steps -1 \
#   --zero_stage 3 \
#   --max_epochs 1 \
#   --bf16 \
#   --flash_attn \
#   --learning_rate 1e-5 \
#   --load_checkpoint \
#   --packing_samples \
#   --gradient_checkpointing

deepspeed --module openrlhf.cli.train_sft \
   --max_len 20480 \
   --dataset sft_data/${prefix}_qwen_type6.jsonl \
   --input_key prompt \
   --output_key response \
   --train_batch_size 64 \
   --micro_train_batch_size 1 \
   --apply_chat_template \
   --max_samples 500000 \
   --pretrain ${model_prefix}/Qwen2.5-7B-Instruct \
   --save_path sft_ckpt/qwen257b_type6_sft \
   --save_steps -1 \
   --logging_steps 1 \
   --eval_steps -1 \
   --zero_stage 3 \
   --max_epochs 1 \
   --bf16 \
   --flash_attn \
   --learning_rate 5e-6 \
   --load_checkpoint \
   --packing_samples \
   --gradient_checkpointing

#for prefix in 'math_500' 'omni_math'; do
#  for type in 'type1' 'type4'; do
#    PYTHONPATH=$PYTHONPATH:$(pwd):$(pwd) python Task_3/offline_inference.py --model_path qwen257b_${type}_sft --input_file eval_data/${prefix}_information_missing_level1_verified_pp.jsonl --output_file Task_3/${prefix}_information_missing_level1_qwen257b_${type}_sft.jsonl
#
#    PYTHONPATH=$PYTHONPATH:$(pwd):$(pwd) python Task_3/offline_inference.py --model_path qwen257b_${type}_sft --input_file eval_data/${prefix}_parsed_reassemble_verified_pp.jsonl --output_file Task_3/${prefix}_qwen257b_${type}_sft.jsonl --use_raw
#  done
#
#  for type in 'type2' 'type5'; do
#    PYTHONPATH=$PYTHONPATH:$(pwd):$(pwd) python Task_3/offline_inference.py --model_path qwen257b_${type}_sft --input_file eval_data/${prefix}_parsed_reassemble_verified_pp.jsonl --output_file Task_3/${prefix}_qwen257b_${type}_sft.jsonl --use_raw
#  done
#
#  for type in 'type3' 'type6'; do
#    PYTHONPATH=$PYTHONPATH:$(pwd):$(pwd) python Task_3/offline_inference.py --model_path qwen257b_${type}_sft --input_file eval_data/${prefix}_information_missing_level1_verified_pp.jsonl --output_file Task_3/${prefix}_information_missing_level1_qwen257b_${type}_sft.jsonl
#  done
#done
for prefix in 'math_500' 'omni_math'; do
  for type in 'type6'; do
    CUDA_VISIBLE_DEVICES=0,1 PYTHONPATH=$PYTHONPATH:$(pwd):$(pwd) python Task_3/offline_inference.py --model_path sft_ckpt/qwen257b_${type}_bs32_sft --input_file eval_data/${prefix}_information_missing_level1_verified_pp.jsonl --output_file Task_3/${prefix}_information_missing_level1_qwen257b_${type}_bs32_sft.jsonl
  done
done

prefix='math_500'
PYTHONPATH=$PYTHONPATH:$(pwd):$(pwd) python Task_3/evaluation.py --input_path_cls Task_3/${prefix}_information_missing_level1_qwen257b_type3_sft.jsonl --input_path_raw Task_3/${prefix}_qwen257b_type1_sft.jsonl
PYTHONPATH=$PYTHONPATH:$(pwd):$(pwd) python Task_3/evaluation.py --input_path_cls Task_3/${prefix}_information_missing_level1_qwen257b_type6_bs32_sft.jsonl --input_path_raw Task_3/${prefix}_qwen257b_type1_sft.jsonl