import jsonlines
import numpy as np
import argparse
from common.utils import async_http_process_requests, simple_promptify, list_to_string
from common.model_configs import config_model, config_aliyun

chat_template = """

# Unclear Task

{unclear_task}

# Instruction

The task is unclear and need additional information, please raise clarification question.
"""


def parse_res(res):
    if '[[Yes]]' in res:
        return 1
    else:
        return 0


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--input_file', type=str)
    parser.add_argument('--save_file', type=str)
    args = parser.parse_args()

    data = list(jsonlines.open(args.input_file))
    prompts = []
    for item in data:
        prompt = chat_template.format(
            unclear_task=item['unclear_task']
        )
        prompts.append(prompt)
    model_config = config_model(config_aliyun, 'deepseek-r1', 0.6, 250)
    requests = simple_promptify(prompts)
    responses = async_http_process_requests(requests, model_config)
    data_to_save = [{
        'answer': res[0],
        'thought': res[1],
        'metadata': item,
    } for res, item in zip(responses, data)]
    with jsonlines.open(args.save_file, 'w') as writer:
        writer.write_all(data_to_save)


if __name__ == '__main__':
    main()
