import argparse
import jsonlines
import numpy as np
from collections import defaultdict

def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--input_file', type=str, required=True)
    args = parser.parse_args()

    data = list(jsonlines.open(args.input_file))
    merge_dict = defaultdict(list)
    for item in data:
        if 'clarification' in item['answer'].lower():
            cls = True
        else:
            cls = False
        merge_dict[item['metadata']['metadata']['raw_task']].append({
            'level': item['metadata']['metadata']['level'],
            'cls': cls,
        })
    cls_level = defaultdict(list)
    for k, vs in merge_dict.items():
        cls_ratio = np.mean([v['cls'] for v in vs])
        cls_level[vs[0]['level']].append(cls_ratio)
    cls_level = {k: np.mean(v) for k, v in cls_level.items()}
    print(cls_level)

if __name__ == '__main__':
    main()
