import jsonlines
import argparse
from evaluation import get_thought_answer


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--input_file')
    parser.add_argument('--output_file')
    args = parser.parse_args()

    data = list(jsonlines.open(args.input_file))
    output_data = []
    for item in data:
        thought, answer = get_thought_answer(item['response'])
        output_data.append(
            {**{
                'answer': answer,
                'thought': thought,
            }, **item}
        )
    with jsonlines.open(args.output_file, 'w') as writer:
        writer.write_all(output_data)


if __name__ == '__main__':
    main()
