import os

import jsonlines


template = 'critic_bench/math_500_parsed_{}_pp.jsonl'
info_missing_file = template.format('information_missing')
info_mismatch_file = template.format('information_mismatch')
purpose_missing_file = template.format('purpose_missing')
purpose_mismatch_file = template.format('purpose_mismatch')

info_missing_data = list(jsonlines.open(info_missing_file))
info_mismatch_data = list(jsonlines.open(info_mismatch_file))
purpose_missing_data = list(jsonlines.open(purpose_missing_file))
purpose_mismatch_data = list(jsonlines.open(purpose_mismatch_file))

def trans_data(data):
    return {item['raw_task']: item['ambiguous_task'] for item in data}

info_missing_data = trans_data(info_missing_data)
info_mismatch_data = trans_data(info_mismatch_data)
purpose_missing_data = trans_data(purpose_missing_data)
purpose_mismatch_data = trans_data(purpose_mismatch_data)

raw_tasks = set(info_mismatch_data.keys()).intersection(info_missing_data.keys()).intersection(info_missing_data.keys()).intersection(info_missing_data.keys())
raw_tasks = sorted(raw_tasks)

for raw_task in raw_tasks:
    os.system('clear')
    info_missing = info_missing_data[raw_task]
    info_mismatch = info_mismatch_data[raw_task]
    purpose_missing = purpose_missing_data[raw_task]
    purpose_mismatch = purpose_mismatch_data[raw_task]

    print('====== raw task ======')
    print(raw_task)
    print('====== info_missing task ======')
    print(info_missing)
    print('====== info_mismatch task ======')
    print(info_mismatch)
    print('====== purpose_missing task ======')
    print(purpose_missing)
    print('====== purpose_mismatch task ======')
    print(purpose_mismatch)
    print('****************************')
    input()
