import jsonlines
from datasets import load_dataset

ds = load_dataset('HuggingFaceH4/MATH-500', split='test')
output_data = []
for item in ds:
    output_data.append({
        'problem': item['problem'],
        'solution': item['solution'],
        'answer': item['answer'],
        'level': item['level'],
    })
with jsonlines.open('critic_bench/math_500.jsonl', 'w') as writer:
    writer.write_all(output_data)
