import jsonlines
import random
import argparse
from common.utils import async_http_process_requests, simple_promptify, list_to_string
from common.model_configs import config_model, config_aliyun


template = """************
Purpose:
{purpose}

Information:
{information}

Background:
{background}
************

Assemble the Purpose, Information, and Background into a coherent text to get a Question.

Generate your output STRICTLY in the following format.
Question:

**Requirements**:
**1. The Question SHOULD CONTAIN ALL contents in the Purpose, Information and Background (if the Background is not None).**
**2. DO NOT ADD ANY content that is not included in the Purpose, Information and Background to the Question.**\
"""


def parse_results(result, metadata):
    return {
        'response': result,
        'metadata': metadata
    }


def main():
    random.seed(42)
    parser = argparse.ArgumentParser()
    parser.add_argument('--input_file', type=str, required=True)
    parser.add_argument('--output_file', type=str, required=True)
    args = parser.parse_args()
    with jsonlines.open(args.input_file) as r:
        data = list(r)
    all_queries, all_metadata = [], []
    for item in data:
        purpose, information, background = item['purpose'], item['filtered_info_list'], item['background']
        query = template.format(
            purpose=purpose, background=background, information=list_to_string(information, '-'),
        )
        all_queries.append(query)
        all_metadata.append(item)
        if len(all_queries) == 1:
            print(query)
            input()
    all_requests = simple_promptify(all_queries)
    model_config = config_model(config_aliyun, 'deepseek-r1', 0.6, 250)
    all_res = async_http_process_requests(all_requests, model_config)
    all_res = [parse_results(res[0], metadata) for res, metadata in zip(all_res, all_metadata)]
    with jsonlines.open(args.output_file, 'w') as writer:
        writer.write_all(all_res)



if __name__ == '__main__':
    main()
