# Learning to Pool in Graph Neural Networks for Extrapolation

This repository is the official implementation of Learning to Pool in Graph Neural Networks for Extrapolation (anonymized). 

## Requirements

To install requirements, run the following command on your terminal:

```setup
pip install -r requirements.txt
```

Additionally, you need to install PyTorch==1.7.1, DGL>=0.6 and PyTorch Geometric==1.7.0. Since the installation commands for the packages rely on the environments, visit following pages to install the packages:

- PyTorch: [https://pytorch.org/get-started/previous-versions/#v171](https://pytorch.org/get-started/previous-versions/#v171)
- DGL: [https://www.dgl.ai/pages/start.html](https://www.dgl.ai/pages/start.html)
- PyTorch Geometric: [https://pytorch-geometric.readthedocs.io/en/latest/notes/installation.html](https://pytorch-geometric.readthedocs.io/en/latest/notes/installation.html)

## Generating datasets for graph-level and node-level tasks

We used the generator from [this github repository](https://github.com/jinglingli/nn-extrapolate) for graph_algorithms. You need to clone the repository before generating the datasets and we used only `graph_algorithms` directory.

### Training datasets

#### Graph-level tasks
In `sample_scripts/sample_maxdeg_uniform.py`, set `train_graphs` as `['general']` and `test_colors` as `[10]`. Then, run the following command in the cloned repository:

```setup
python sample_scripts/sample_maxdeg_uniform.py
```

#### Node-level tasks
In `sample_scripts/sample_shortest_uniform.py`, set `train_graphs` as `['general']` and `max_weight_tests` as `[10]`. Also you need to change `VAL_RATIO`, `TEST_RATIO` and default value of `args.num_graphs` to `0.2`, `0.5` and `5000` in `shortest_generation.py`, respectively. Then, run the following command in the cloned repository:

```setup
python sample_scripts/sample_shortest_uniform.py
```

### Generating different types of graphs for test
From the original codes, overwrite `sample_scripts/sample_maxdeg_uniform.py`, `sample_scripts/sample_shortest_uniform.py`, `maxdeg_generation.py` and `shortest_generation.py` to the provided files in `generate_data` directory, then run the following commands in the cloned repository.

```setup
python sample_scripts/sample_maxdeg_uniform.py
python sample_scripts/sample_shortest_uniform.py
```

### Convering generated datasets

You should convert the generated datasets before running training and evaluation. To convert the datasets, you need to copy `util.py` to the directory `generate_data/convert` in the provided files. then run the following commands in the provided files.

```setup
cd ./generate_data/convert
python convert.py
```

The converted files will be stored in `converted` directory.

### Example datasets

We provided example datasets for both tasks. See the directories `graph/data/` and `node/data/`. You should extract the files before training/evaluation.

## Arguments for training and evaluation (for extrapolation experiments)

Some arguments are unused or omitted depending on tasks.

- `--lr`: learning rate for parameters except for p
- `--lr-pool`: learning rate for p
- `--n-epochs`: number of training epochs
- `--n-hidden`: number of hidden units (hidden dimension)
- `--n-layers`: number of GIN layers (for graph/node-level tasks) / Linear layers (for set-related tasks) before the last linear layer
- `--weight-decay`: weight for L2 loss
- `--aggregator-type`: pooling function for aggregation (Supported functions: general(GNP)/sum/max/mean/min)
- `--pooling-type`: pooling function for readout (Supported functions: general(GNP)/sum/max/mean/min/sort/set2set/sagpool/transformer)
- `--batch-size`: batch size
- `--norm-limit`: maximum norm of the gradients for clipping
- `--task`: target task
- `--opt-fn`: optimizer function (Supported functions: rmsprop/adam/adamgan(adam with beta_1=0.5 and beta_2=0.999))
- `--gpu`: gpu id for execution
- `--gtype`: (For GNP) `0`: use both GNP+/GNP-, `1`: use GNP^+ only, `2`: use GNP^- only / (For SortPooling): number of nodes to hold after pooling / (For Set2Set) number of iterations / (For Set Transformer) `0`: 2 ISAB blocks for encoder, `1`: 2 SAB blocks for encoder
- `--graph`: type of graphs for training/evaluation
- `--seed`: random seed

## Training

To train the model(s) in the paper, we provide the following example commands:

- For graph-level tasks (except for SAGPool)
```train
cd graph
python train.py --lr 3e-3 --lr-pool 3e-2 --aggregator-type general --pooling-type general --norm-limit 1e2 --task maxdegree --gpu 0 --gtype 0 --graph general --seed 0
python train.py --lr 3e-3 --lr-pool 1e-2 --aggregator-type general --pooling-type general --norm-limit 1e2 --task harmonic --gpu 0 --gtype 0 --graph general --seed 0
python train.py --lr 3e-3 --lr-pool 1e-2 --aggregator-type general --pooling-type general --norm-limit 1e2 --task invsize --gpu 0 --gtype 0 --graph general --seed 0
python train_readout.py --lr 1e-3 --lr-pool 1e-3 --aggregator-type sum --pooling-type sort --norm-limit 1e2 --task maxdegree --gpu 0 --gtype 20 --graph general --seed 0
```

- For graph-level tasks (SAGPool)
```train
cd graph_sagpool
python train.py --lr 1e-2 --lr-pool 1e-2 --pooling-type sagpool --norm-limit 1e4 --task maxdegree --gpu 0 --graph general --seed 0
```

- For node-level tasks
```train
cd node
python train.py --lr 3e-3 --lr-pool 1e-2 --aggregator-type general --norm-limit 1e4 --task bfs --gpu 0 --gtype 0 --graph general --seed 0
python train.py --lr 3e-3 --lr-pool 3e-2 --aggregator-type general --norm-limit 1e4 --task shortest --gpu 0 --gtype 0 --graph general --seed 0
```

- For set-related tasks
```train
cd set
python train.py --lr 3e-3 --lr-pool 1e-2 --task map_sigma --gtype 0 --seed 0
python train.py --lr 3e-3 --lr-pool 3e-2 --task closed_form --gtype 0 --seed 0
python train.py --lr 3e-3 --lr-pool 3e-2 --task map_mu --gtype 0 --seed 0
```

- For graph classification
```train
cd classification-sagpool
# CUDA_VISIBLE_DEVICES=[gpu-id] python kfold.py --seed [seed] --batch_size [batch_size] --lr [learning-rate] --lr-pool [learning-rate-for-p] --weight_decay [weight-decay] --nhid [hidden-size] --pooling_ratio [pooling-ratio] --dropout_ratio [dropout_ratio] --dataset [DD|PROTEINS|NCI1] --epochs [maximum-epochs] --patience [patience-for-early-stopping]
CUDA_VISIBLE_DEVICES=0 python kfold.py --seed 0 --lr 0.0005 --lr-pool 0.0005 --nhid 128 --weight_decay 0.0001 --pooling_ratio 0.5 --dataset DD
```
```train
cd classification-asapool
# CUDA_VISIBLE_DEVICES=[gpu-id] python main.py -data [DD|PROTEINS|NCI1] -batch [batch_size] -hid_dim [hidden-size] -dropout_att [dropout-ratio] -lr [learning-rate]
CUDA_VISIBLE_DEVICES=0 python main.py -data PROTEINS -batch 128 -hid_dim 64 -dropout_att 0.1 -lr 0.01
```

- For Influence Maximization
```train
cd influence-maximization
# CUDA_VISIBLE_DEVICES=[gpu-id] python train.py  --target [Extended|Celebrity|WannaCry] --input-dim [4] --hidden-dim [hidden-size] --layer-num [number-of-layers] --lamb [lambda-for-loss-function] --lr [learning-rate] --epochs [maximum-epochs] --model-type [2] --seed [seed]
CUDA_VISIBLE_DEVICES=0 python train.py --target=Extended --input-dim=4 --hidden-dim=16 --layer-num=3 --lamb=0.3 --lr 1e-3 --epochs=100 --model-type 2 --seed 0
```

Note that the output values for p+ and p- are t+ and t-, respectively. So you need to convert the values to get exact values of p+ and p- (See Section 3.3).

For all experiments, you can freely change the arguments to change the options for training.

## Evaluation

To evaluate the model(s), we provide the following example commands:

- For graph-level tasks (except for SAGPool)
```test
cd graph
python test.py --lr 3e-3 --lr-pool 3e-2 --aggregator-type general --pooling-type general --norm-limit 1e2 --task maxdegree --gpu 0 --gtype 0 --graph general --seed 0
python test.py --lr 3e-3 --lr-pool 1e-2 --aggregator-type general --pooling-type general --norm-limit 1e2 --task harmonic --gpu 0 --gtype 0 --graph general --seed 0
python test.py --lr 3e-3 --lr-pool 1e-2 --aggregator-type general --pooling-type general --norm-limit 1e2 --task invsize --gpu 0 --gtype 0 --graph general --seed 0
python test.py --lr 1e-3 --lr-pool 1e-3 --aggregator-type sum --pooling-type sort --norm-limit 1e2 --task maxdegree --gpu 0 --gtype 20 --graph general --seed 0
```

- For graph-level tasks (SAGPool)
```train
cd graph_sagpool
python test.py --lr 1e-2 --lr-pool 1e-2 --pooling-type sagpool --norm-limit 1e4 --task maxdegree --gpu 0 --graph general --seed 0
```

- For node-level tasks
```test
cd node
python test.py --lr 3e-3 --lr-pool 1e-2 --aggregator-type general --norm-limit 1e4 --task bfs --gpu 0 --gtype 0 --graph general --seed 0
python test.py --lr 3e-3 --lr-pool 3e-2 --aggregator-type general --norm-limit 1e4 --task shortest --gpu 0 --gtype 0 --graph general --seed 0
```

Note that the output values for p+ and p- are t+ and t-, respectively. So you need to convert the values to get exact values of p+ and p- (See Section 3.3).

## Examples

We provided the examples for training/evaluation. See `graph/example.sh`, `node/example.sh`, and `set/example.sh`. To run example tests, you need to move checkpoints in `example_checkpoints` directory to `checkpoints` directory.

## Results

For more results, see the original paper.

### Test MAPE on graph-level tasks

| maxdegree | harmonic  | invsize   |
|---------- | --------- | --------- |
| 2.5 ± 0.4 | 1.1 ± 0.8 | 1.2 ± 0.3 |

### Test MAE on node-level tasks

| bfs       | shortest  |
|---------- | --------- |
| 0.000 ± 0.001 | 0.332 ± 0.105 |

### Test MAPE on set-related tasks

| mu_post | sigma^2_post | mu_MAP | sigma^2_MAP |
| --------- | --------- | --------- | --------- |
| 1.5 ± 0.6 | 0.7 ± 0.3 | 1.5 ± 0.6 | 3.1 ± 0.5 |


## About license

This repository is licensed under the MIT License.


Here is a license (Apache License 2.0) of DGL (https://github.com/dmlc/dgl), and we modified and re-distributed the following files in this repository:
- `graph/model.py`, `node/model.py`: We modified [GINConv](https://github.com/dmlc/dgl/blob/master/python/dgl/nn/pytorch/conv/ginconv.py) and [GIN](https://github.com/dmlc/dgl/blob/master/examples/pytorch/gin/gin.py) to apply GNP on the existing GIN model.
- `graph/[train|test]*.py`, `graph_sagpool/[train|test]*.py`, `node/[train|test]*.py`, `set/train*.py`: We modified [train_full.py](https://github.com/dmlc/dgl/blob/master/examples/pytorch/graphsage/train_full.py) for training/evaluating model.
- `graph_sagpool/network.py`, `graph_sagpool/layer.py`, `graph_sagpool/utils.py`: All files are from [SAGPool example](https://github.com/dmlc/dgl/tree/master/examples/pytorch/sagpool), and we modified `network.py` to change the output format of the model.

                                 Apache License
                           Version 2.0, January 2004
                        http://www.apache.org/licenses/

   TERMS AND CONDITIONS FOR USE, REPRODUCTION, AND DISTRIBUTION

   1. Definitions.

      "License" shall mean the terms and conditions for use, reproduction,
      and distribution as defined by Sections 1 through 9 of this document.

      "Licensor" shall mean the copyright owner or entity authorized by
      the copyright owner that is granting the License.

      "Legal Entity" shall mean the union of the acting entity and all
      other entities that control, are controlled by, or are under common
      control with that entity. For the purposes of this definition,
      "control" means (i) the power, direct or indirect, to cause the
      direction or management of such entity, whether by contract or
      otherwise, or (ii) ownership of fifty percent (50%) or more of the
      outstanding shares, or (iii) beneficial ownership of such entity.

      "You" (or "Your") shall mean an individual or Legal Entity
      exercising permissions granted by this License.

      "Source" form shall mean the preferred form for making modifications,
      including but not limited to software source code, documentation
      source, and configuration files.

      "Object" form shall mean any form resulting from mechanical
      transformation or translation of a Source form, including but
      not limited to compiled object code, generated documentation,
      and conversions to other media types.

      "Work" shall mean the work of authorship, whether in Source or
      Object form, made available under the License, as indicated by a
      copyright notice that is included in or attached to the work
      (an example is provided in the Appendix below).

      "Derivative Works" shall mean any work, whether in Source or Object
      form, that is based on (or derived from) the Work and for which the
      editorial revisions, annotations, elaborations, or other modifications
      represent, as a whole, an original work of authorship. For the purposes
      of this License, Derivative Works shall not include works that remain
      separable from, or merely link (or bind by name) to the interfaces of,
      the Work and Derivative Works thereof.

      "Contribution" shall mean any work of authorship, including
      the original version of the Work and any modifications or additions
      to that Work or Derivative Works thereof, that is intentionally
      submitted to Licensor for inclusion in the Work by the copyright owner
      or by an individual or Legal Entity authorized to submit on behalf of
      the copyright owner. For the purposes of this definition, "submitted"
      means any form of electronic, verbal, or written communication sent
      to the Licensor or its representatives, including but not limited to
      communication on electronic mailing lists, source code control systems,
      and issue tracking systems that are managed by, or on behalf of, the
      Licensor for the purpose of discussing and improving the Work, but
      excluding communication that is conspicuously marked or otherwise
      designated in writing by the copyright owner as "Not a Contribution."

      "Contributor" shall mean Licensor and any individual or Legal Entity
      on behalf of whom a Contribution has been received by Licensor and
      subsequently incorporated within the Work.

   2. Grant of Copyright License. Subject to the terms and conditions of
      this License, each Contributor hereby grants to You a perpetual,
      worldwide, non-exclusive, no-charge, royalty-free, irrevocable
      copyright license to reproduce, prepare Derivative Works of,
      publicly display, publicly perform, sublicense, and distribute the
      Work and such Derivative Works in Source or Object form.

   3. Grant of Patent License. Subject to the terms and conditions of
      this License, each Contributor hereby grants to You a perpetual,
      worldwide, non-exclusive, no-charge, royalty-free, irrevocable
      (except as stated in this section) patent license to make, have made,
      use, offer to sell, sell, import, and otherwise transfer the Work,
      where such license applies only to those patent claims licensable
      by such Contributor that are necessarily infringed by their
      Contribution(s) alone or by combination of their Contribution(s)
      with the Work to which such Contribution(s) was submitted. If You
      institute patent litigation against any entity (including a
      cross-claim or counterclaim in a lawsuit) alleging that the Work
      or a Contribution incorporated within the Work constitutes direct
      or contributory patent infringement, then any patent licenses
      granted to You under this License for that Work shall terminate
      as of the date such litigation is filed.

   4. Redistribution. You may reproduce and distribute copies of the
      Work or Derivative Works thereof in any medium, with or without
      modifications, and in Source or Object form, provided that You
      meet the following conditions:

      (a) You must give any other recipients of the Work or
          Derivative Works a copy of this License; and

      (b) You must cause any modified files to carry prominent notices
          stating that You changed the files; and

      (c) You must retain, in the Source form of any Derivative Works
          that You distribute, all copyright, patent, trademark, and
          attribution notices from the Source form of the Work,
          excluding those notices that do not pertain to any part of
          the Derivative Works; and

      (d) If the Work includes a "NOTICE" text file as part of its
          distribution, then any Derivative Works that You distribute must
          include a readable copy of the attribution notices contained
          within such NOTICE file, excluding those notices that do not
          pertain to any part of the Derivative Works, in at least one
          of the following places: within a NOTICE text file distributed
          as part of the Derivative Works; within the Source form or
          documentation, if provided along with the Derivative Works; or,
          within a display generated by the Derivative Works, if and
          wherever such third-party notices normally appear. The contents
          of the NOTICE file are for informational purposes only and
          do not modify the License. You may add Your own attribution
          notices within Derivative Works that You distribute, alongside
          or as an addendum to the NOTICE text from the Work, provided
          that such additional attribution notices cannot be construed
          as modifying the License.

      You may add Your own copyright statement to Your modifications and
      may provide additional or different license terms and conditions
      for use, reproduction, or distribution of Your modifications, or
      for any such Derivative Works as a whole, provided Your use,
      reproduction, and distribution of the Work otherwise complies with
      the conditions stated in this License.

   5. Submission of Contributions. Unless You explicitly state otherwise,
      any Contribution intentionally submitted for inclusion in the Work
      by You to the Licensor shall be under the terms and conditions of
      this License, without any additional terms or conditions.
      Notwithstanding the above, nothing herein shall supersede or modify
      the terms of any separate license agreement you may have executed
      with Licensor regarding such Contributions.

   6. Trademarks. This License does not grant permission to use the trade
      names, trademarks, service marks, or product names of the Licensor,
      except as required for reasonable and customary use in describing the
      origin of the Work and reproducing the content of the NOTICE file.

   7. Disclaimer of Warranty. Unless required by applicable law or
      agreed to in writing, Licensor provides the Work (and each
      Contributor provides its Contributions) on an "AS IS" BASIS,
      WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
      implied, including, without limitation, any warranties or conditions
      of TITLE, NON-INFRINGEMENT, MERCHANTABILITY, or FITNESS FOR A
      PARTICULAR PURPOSE. You are solely responsible for determining the
      appropriateness of using or redistributing the Work and assume any
      risks associated with Your exercise of permissions under this License.

   8. Limitation of Liability. In no event and under no legal theory,
      whether in tort (including negligence), contract, or otherwise,
      unless required by applicable law (such as deliberate and grossly
      negligent acts) or agreed to in writing, shall any Contributor be
      liable to You for damages, including any direct, indirect, special,
      incidental, or consequential damages of any character arising as a
      result of this License or out of the use or inability to use the
      Work (including but not limited to damages for loss of goodwill,
      work stoppage, computer failure or malfunction, or any and all
      other commercial damages or losses), even if such Contributor
      has been advised of the possibility of such damages.

   9. Accepting Warranty or Additional Liability. While redistributing
      the Work or Derivative Works thereof, You may choose to offer,
      and charge a fee for, acceptance of support, warranty, indemnity,
      or other liability obligations and/or rights consistent with this
      License. However, in accepting such obligations, You may act only
      on Your own behalf and on Your sole responsibility, not on behalf
      of any other Contributor, and only if You agree to indemnify,
      defend, and hold each Contributor harmless for any liability
      incurred by, or claims asserted against, such Contributor by reason
      of your accepting any such warranty or additional liability.

   END OF TERMS AND CONDITIONS

   APPENDIX: How to apply the Apache License to your work.

      To apply the Apache License to your work, attach the following
      boilerplate notice, with the fields enclosed by brackets "[]"
      replaced with your own identifying information. (Don't include
      the brackets!)  The text should be enclosed in the appropriate
      comment syntax for the file format. We also recommend that a
      file or class name and description of purpose be included on the
      same "printed page" as the copyright notice for easier
      identification within third-party archives.

   Copyright [yyyy] [name of copyright owner]

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.